/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.java;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.drools.compiler.compiler.AnalysisResult;
import org.drools.compiler.compiler.BoundIdentifiers;
import org.drools.compiler.compiler.DescrBuildError;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.rule.builder.AccumulateBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.compiler.rule.builder.dialect.java.JavaAnalysisResult;
import org.drools.compiler.rule.builder.dialect.java.JavaRuleBuilderHelper;
import org.drools.compiler.rule.builder.dialect.java.parser.JavaLocalDeclarationDescr;
import org.drools.compiler.rule.builder.util.PackageBuilderUtil;
import org.drools.core.base.accumulators.JavaAccumulatorFunctionExecutor;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.Accumulator;
import org.drools.core.spi.DeclarationScopeResolver;
import org.drools.core.spi.InternalReadAccessor;
import org.kie.api.runtime.rule.AccumulateFunction;

public class JavaAccumulateBuilder
implements AccumulateBuilder {
    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        return this.build(context, descr, null);
    }

    @Override
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        RuleConditionBuilder builder;
        RuleConditionElement source;
        AccumulateDescr accumDescr = (AccumulateDescr)descr;
        if (!accumDescr.hasValidInput()) {
            return null;
        }
        BaseDescr input = accumDescr.getInput();
        if (input instanceof AndDescr && ((AndDescr)input).getDescrs().size() == 1) {
            input = ((AndDescr)input).getDescrs().get(0);
        }
        if ((source = (builder = (RuleConditionBuilder)context.getDialect().getBuilder(input.getClass())).build(context, input)) == null) {
            return null;
        }
        boolean readLocalsFromTuple = PackageBuilderUtil.isReadLocalsFromTuple(accumDescr, source);
        Map declsInScope = context.getDeclarationResolver().getDeclarations(context.getRule());
        Map declCls = DeclarationScopeResolver.getDeclarationClasses((Map)declsInScope);
        Accumulate accumulate = accumDescr.isExternalFunction() ? this.buildExternalFunctionCall(context, accumDescr, source, declsInScope, declCls, readLocalsFromTuple) : this.buildInlineAccumulate(context, accumDescr, source, declsInScope, declCls, readLocalsFromTuple);
        return accumulate;
    }

    private Accumulate buildExternalFunctionCall(RuleBuildContext context, AccumulateDescr accumDescr, RuleConditionElement source, Map<String, Declaration> declsInScope, Map<String, Class<?>> declCls, boolean readLocalsFromTuple) {
        List<AccumulateDescr.AccumulateFunctionCallDescr> funcCalls = accumDescr.getFunctions();
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
        Arrays.sort(sourceDeclArr, RuleTerminalNode.SortDeclarations.instance);
        Accumulator[] accumulators = new Accumulator[funcCalls.size()];
        HashSet<Declaration> requiredDecl = new HashSet<Declaration>();
        SelfReferenceClassFieldReader arrayReader = new SelfReferenceClassFieldReader(Object[].class, "this");
        int index = 0;
        Pattern pattern = (Pattern)context.getBuildStack().peek();
        for (AccumulateDescr.AccumulateFunctionCallDescr fc : funcCalls) {
            AccumulateFunction function = context.getConfiguration().getAccumulateFunction(fc.getFunction());
            if (function == null) {
                context.addError(new DescrBuildError(accumDescr, context.getRuleDescr(), null, "Unknown accumulate function: '" + fc.getFunction() + "' on rule '" + context.getRuleDescr().getName() + "'. All accumulate functions must be registered before building a resource."));
                return null;
            }
            if (fc.getBind() != null) {
                if (pattern.getDeclaration(fc.getBind()) != null) {
                    context.addError(new DescrBuildError(context.getParentDescr(), accumDescr, null, "Duplicate declaration for variable '" + fc.getBind() + "' in the rule '" + context.getRule().getName() + "'"));
                } else {
                    this.createResultBind(pattern, index, (InternalReadAccessor)arrayReader, fc, function);
                }
            }
            JavaAnalysisResult analysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, fc.getParams().length > 0 ? fc.getParams()[0] : "\"\"", new BoundIdentifiers(declCls, context.getPackageBuilder().getGlobals()));
            BoundIdentifiers usedIdentifiers = analysis.getBoundIdentifiers();
            Declaration[] previousDeclarations = this.collectRequiredDeclarations(declsInScope, requiredDecl, usedIdentifiers);
            accumulators[index++] = this.generateFunctionCallCodeTemplate(context, accumDescr, sourceDeclArr, fc, function, usedIdentifiers, previousDeclarations, readLocalsFromTuple);
        }
        return new Accumulate(source, requiredDecl.toArray(new Declaration[requiredDecl.size()]), accumulators, accumDescr.isMultiFunction());
    }

    private Declaration[] collectRequiredDeclarations(Map<String, Declaration> declsInScope, Set<Declaration> requiredDecl, BoundIdentifiers usedIdentifiers) {
        Declaration[] previousDeclarations = new Declaration[usedIdentifiers.getDeclrClasses().size()];
        int i = 0;
        for (String key : usedIdentifiers.getDeclrClasses().keySet()) {
            Declaration d = declsInScope.get(key);
            previousDeclarations[i++] = d;
            requiredDecl.add(d);
        }
        return previousDeclarations;
    }

    private JavaAccumulatorFunctionExecutor generateFunctionCallCodeTemplate(RuleBuildContext context, AccumulateDescr accumDescr, Declaration[] sourceDeclArr, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function, BoundIdentifiers usedIdentifiers, Declaration[] previousDeclarations, boolean readLocalsFromTuple) {
        String className = "accumulateExpression" + context.getNextId();
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, fc.getParams().length > 0 ? fc.getParams()[0] : "\"\"", context, previousDeclarations, sourceDeclArr, usedIdentifiers.getGlobals());
        map.put("readLocalsFromTuple", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
        JavaAccumulatorFunctionExecutor accumulator = new JavaAccumulatorFunctionExecutor(function);
        JavaRuleBuilderHelper.generateTemplates("returnValueMethod", "returnValueInvoker", context, className, map, accumulator, accumDescr);
        return accumulator;
    }

    private void createResultBind(Pattern pattern, int index, InternalReadAccessor arrayReader, AccumulateDescr.AccumulateFunctionCallDescr fc, AccumulateFunction function) {
        Declaration declr = pattern.addDeclaration(fc.getBind());
        Class type = function.getResultType();
        ArrayElementReader reader = new ArrayElementReader(arrayReader, index, type);
        declr.setReadAccessor((InternalReadAccessor)reader);
    }

    private Accumulate buildInlineAccumulate(RuleBuildContext context, AccumulateDescr accumDescr, RuleConditionElement source, Map<String, Declaration> decls, Map<String, Class<?>> declCls, boolean readLocalsFromTuple) {
        Accumulate accumulate;
        String className = "Accumulate" + context.getNextId();
        accumDescr.setClassName(className);
        BoundIdentifiers available = new BoundIdentifiers(declCls, context.getPackageBuilder().getGlobals());
        JavaAnalysisResult initCodeAnalysis = (JavaAnalysisResult)context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getInitCode(), available);
        AnalysisResult actionCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), available);
        AnalysisResult resultCodeAnalysis = context.getDialect().analyzeExpression(context, accumDescr, accumDescr.getResultCode(), available);
        HashSet<String> requiredDeclarations = new HashSet<String>(initCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
        requiredDeclarations.addAll(actionCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
        requiredDeclarations.addAll(resultCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
        HashMap requiredGlobals = new HashMap(initCodeAnalysis.getBoundIdentifiers().getGlobals());
        requiredGlobals.putAll(actionCodeAnalysis.getBoundIdentifiers().getGlobals());
        requiredGlobals.putAll(resultCodeAnalysis.getBoundIdentifiers().getGlobals());
        if (accumDescr.getReverseCode() != null) {
            AnalysisResult reverseCodeAnalysis = context.getDialect().analyzeBlock(context, accumDescr, accumDescr.getActionCode(), available);
            requiredDeclarations.addAll(reverseCodeAnalysis.getBoundIdentifiers().getDeclrClasses().keySet());
            requiredGlobals.putAll(reverseCodeAnalysis.getBoundIdentifiers().getGlobals());
        }
        Declaration[] declarations = new Declaration[requiredDeclarations.size()];
        int i = 0;
        Iterator it = requiredDeclarations.iterator();
        while (it.hasNext()) {
            declarations[i] = decls.get(it.next());
            ++i;
        }
        Declaration[] sourceDeclArr = source.getOuterDeclarations().values().toArray(new Declaration[0]);
        Arrays.sort(sourceDeclArr, RuleTerminalNode.SortDeclarations.instance);
        Map<String, Object> map = JavaRuleBuilderHelper.createVariableContext(className, null, context, declarations, null, requiredGlobals);
        map.put("className", accumDescr.getClassName());
        map.put("innerDeclarations", sourceDeclArr);
        map.put("isMultiPattern", readLocalsFromTuple ? Boolean.TRUE : Boolean.FALSE);
        String initCode = this.fixInitCode(initCodeAnalysis, accumDescr.getInitCode());
        String actionCode = accumDescr.getActionCode();
        String resultCode = accumDescr.getResultCode();
        String[] attributesTypes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
        String[] attributes = new String[initCodeAnalysis.getLocalVariablesMap().size()];
        int index = 0;
        for (Map.Entry<String, JavaLocalDeclarationDescr> entry : initCodeAnalysis.getLocalVariablesMap().entrySet()) {
            attributes[index] = entry.getKey();
            attributesTypes[index] = entry.getValue().getType();
            ++index;
        }
        map.put("attributes", attributes);
        map.put("attributesTypes", attributesTypes);
        map.put("initCode", initCode);
        map.put("actionCode", actionCode);
        map.put("resultCode", resultCode);
        if (accumDescr.getReverseCode() == null) {
            map.put("reverseCode", "");
            map.put("supportsReverse", "false");
        } else {
            map.put("reverseCode", accumDescr.getReverseCode());
            map.put("supportsReverse", "true");
        }
        map.put("hashCode", actionCode.hashCode());
        Accumulate accumulate2 = accumulate = new Accumulate(source, declarations);
        accumulate2.getClass();
        JavaRuleBuilderHelper.generateTemplates("accumulateInnerClass", "accumulateInvoker", context, className, map, new Accumulate.Wirer(accumulate2, 0), accumDescr);
        return accumulate;
    }

    protected String fixInitCode(JavaAnalysisResult analysis, String originalCode) {
        TreeSet<JavaLocalDeclarationDescr> locals = new TreeSet<JavaLocalDeclarationDescr>(new Comparator<JavaLocalDeclarationDescr>(){

            @Override
            public int compare(JavaLocalDeclarationDescr o1, JavaLocalDeclarationDescr o2) {
                return o1.getStart() - o2.getStart();
            }
        });
        for (JavaLocalDeclarationDescr local : analysis.getLocalVariablesMap().values()) {
            locals.add(local);
        }
        StringBuilder initCode = new StringBuilder();
        int lastAdded = 0;
        for (JavaLocalDeclarationDescr d : locals) {
            initCode.append(originalCode.substring(lastAdded, d.getStart()));
            lastAdded = d.getEnd();
            for (JavaLocalDeclarationDescr.IdentifierDescr id : d.getIdentifiers()) {
                initCode.append(originalCode.substring(id.getStart(), id.getEnd()));
                initCode.append(";");
                for (lastAdded = id.getEnd(); lastAdded < originalCode.length() && (Character.isWhitespace(originalCode.charAt(lastAdded)) || originalCode.charAt(lastAdded) == ';'); ++lastAdded) {
                }
            }
        }
        initCode.append(originalCode.substring(lastAdded));
        return initCode.toString();
    }
}

