/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder.dialect.mvel;

import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectConfiguration;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.rule.builder.dialect.mvel.MVELDialect;
import org.drools.core.rule.Package;

public class MVELDialectConfiguration
implements DialectConfiguration {
    private PackageBuilderConfiguration conf;
    private boolean strict;
    private int langLevel;

    @Override
    public Dialect newDialect(PackageBuilder packageBuilder, PackageRegistry pkgRegistry, Package pkg) {
        return new MVELDialect(packageBuilder, pkgRegistry, pkg);
    }

    @Override
    public void init(PackageBuilderConfiguration conf) {
        this.conf = conf;
        this.setStrict(this.determineStrict());
        this.setLangLevel(this.determineLangLevel());
    }

    @Override
    public PackageBuilderConfiguration getPackageBuilderConfiguration() {
        return this.conf;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setLangLevel(int langLevel) {
        this.langLevel = langLevel;
    }

    public int getLangLevel() {
        return this.langLevel;
    }

    private boolean determineStrict() {
        String prop = this.conf.getChainedProperties().getProperty("drools.dialect.mvel.strict", "true");
        return Boolean.valueOf(prop);
    }

    private int determineLangLevel() {
        String prop = this.conf.getChainedProperties().getProperty("drools.dialect.mvel.langLevel", "4");
        return Integer.valueOf(prop);
    }
}

