/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.solver.move.ExaminationMoveHelper;

public class ExamSwapMove
implements Move {
    private Exam leftExam;
    private Exam rightExam;

    public ExamSwapMove(Exam leftExam, Exam rightExam) {
        this.leftExam = leftExam;
        this.rightExam = rightExam;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.leftExam.getPeriod(), (Object)this.rightExam.getPeriod()) || !ObjectUtils.equals((Object)this.leftExam.getRoom(), (Object)this.rightExam.getRoom());
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new ExamSwapMove(this.rightExam, this.leftExam);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Period oldLeftPeriod = this.leftExam.getPeriod();
        Period oldRightPeriod = this.rightExam.getPeriod();
        Room oldLeftRoom = this.leftExam.getRoom();
        Room oldRightRoom = this.rightExam.getRoom();
        if (oldLeftPeriod.equals(oldRightPeriod)) {
            ExaminationMoveHelper.moveRoom(scoreDirector, this.leftExam, oldRightRoom);
            ExaminationMoveHelper.moveRoom(scoreDirector, this.rightExam, oldLeftRoom);
        } else if (oldLeftRoom.equals(oldRightRoom)) {
            ExaminationMoveHelper.movePeriod(scoreDirector, this.leftExam, oldRightPeriod);
            ExaminationMoveHelper.movePeriod(scoreDirector, this.rightExam, oldLeftPeriod);
        } else {
            ExaminationMoveHelper.moveExam(scoreDirector, this.leftExam, oldRightPeriod, oldRightRoom);
            ExaminationMoveHelper.moveExam(scoreDirector, this.rightExam, oldLeftPeriod, oldLeftRoom);
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftExam, this.rightExam);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftExam.getPeriod(), this.leftExam.getRoom(), this.rightExam.getPeriod(), this.rightExam.getRoom());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExamSwapMove) {
            ExamSwapMove other = (ExamSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftExam, (Object)other.leftExam).append((Object)this.rightExam, (Object)other.rightExam).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftExam).append((Object)this.rightExam).toHashCode();
    }

    public String toString() {
        return this.leftExam + " <=> " + this.rightExam;
    }
}

