/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.manners2009.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.value.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.score.buildin.simple.SimpleScoreDefinition;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.manners2009.domain.Guest;
import org.optaplanner.examples.manners2009.domain.Hobby;
import org.optaplanner.examples.manners2009.domain.HobbyPractician;
import org.optaplanner.examples.manners2009.domain.Job;
import org.optaplanner.examples.manners2009.domain.JobType;
import org.optaplanner.examples.manners2009.domain.Seat;
import org.optaplanner.examples.manners2009.domain.SeatDesignation;
import org.optaplanner.examples.manners2009.domain.Table;
import org.optaplanner.persistence.xstream.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="Manners2009")
public class Manners2009
extends AbstractPersistable
implements Solution<SimpleScore> {
    private List<Job> jobList;
    private List<Guest> guestList;
    private List<HobbyPractician> hobbyPracticianList;
    private List<Table> tableList;
    private List<Seat> seatList;
    private List<SeatDesignation> seatDesignationList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={SimpleScoreDefinition.class})
    private SimpleScore score;

    public List<Job> getJobList() {
        return this.jobList;
    }

    public void setJobList(List<Job> jobList) {
        this.jobList = jobList;
    }

    public List<Guest> getGuestList() {
        return this.guestList;
    }

    public void setGuestList(List<Guest> guestList) {
        this.guestList = guestList;
    }

    public List<HobbyPractician> getHobbyPracticianList() {
        return this.hobbyPracticianList;
    }

    public void setHobbyPracticianList(List<HobbyPractician> hobbyPracticianList) {
        this.hobbyPracticianList = hobbyPracticianList;
    }

    public List<Table> getTableList() {
        return this.tableList;
    }

    public void setTableList(List<Table> tableList) {
        this.tableList = tableList;
    }

    @ValueRangeProvider(id="seatRange")
    public List<Seat> getSeatList() {
        return this.seatList;
    }

    public void setSeatList(List<Seat> seatList) {
        this.seatList = seatList;
    }

    @PlanningEntityCollectionProperty
    public List<SeatDesignation> getSeatDesignationList() {
        return this.seatDesignationList;
    }

    public void setSeatDesignationList(List<SeatDesignation> seatDesignationList) {
        this.seatDesignationList = seatDesignationList;
    }

    @Override
    public SimpleScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(SimpleScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<Object> facts = new ArrayList<Object>();
        facts.addAll(EnumSet.allOf(JobType.class));
        facts.addAll(this.jobList);
        facts.addAll(this.guestList);
        facts.addAll(EnumSet.allOf(Hobby.class));
        facts.addAll(this.hobbyPracticianList);
        facts.addAll(this.tableList);
        facts.addAll(this.seatList);
        return facts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof Manners2009)) {
            return false;
        }
        Manners2009 other = (Manners2009)o;
        if (this.seatDesignationList.size() != other.seatDesignationList.size()) {
            return false;
        }
        Iterator<SeatDesignation> it = this.seatDesignationList.iterator();
        Iterator<SeatDesignation> otherIt = other.seatDesignationList.iterator();
        while (it.hasNext()) {
            SeatDesignation otherSeatDesignation;
            SeatDesignation seatDesignation = it.next();
            if (seatDesignation.solutionEquals(otherSeatDesignation = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (SeatDesignation seatDesignation : this.seatDesignationList) {
            hashCodeBuilder.append(seatDesignation.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

