/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nurserostering.swingui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang.ObjectUtils;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.nurserostering.domain.Employee;
import org.optaplanner.examples.nurserostering.domain.NurseRoster;
import org.optaplanner.examples.nurserostering.domain.NurseRosterInfo;
import org.optaplanner.examples.nurserostering.domain.Shift;
import org.optaplanner.examples.nurserostering.domain.ShiftAssignment;
import org.optaplanner.examples.nurserostering.domain.ShiftDate;
import org.optaplanner.examples.nurserostering.swingui.EmployeePanel;

public class NurseRosteringPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/nurserostering/swingui/nurseRosteringLogo.png";
    private final ImageIcon employeeIcon = new ImageIcon(this.getClass().getResource("employee.png"));
    private final ImageIcon deleteEmployeeIcon = new ImageIcon(this.getClass().getResource("deleteEmployee.png"));
    private JPanel employeeListPanel;
    private JTextField planningWindowStartField;
    private JButton advancePlanningWindowStartButton;
    private EmployeePanel unassignedPanel;
    private Map<Employee, EmployeePanel> employeeToPanelMap;
    private Map<ShiftAssignment, EmployeePanel> shiftAssignmentToPanelMap;

    public NurseRosteringPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.createEmployeeListPanel();
        JPanel headerPanel = this.createHeaderPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(this.employeeListPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(this.employeeListPanel, -2, -2, -2));
    }

    public ImageIcon getEmployeeIcon() {
        return this.employeeIcon;
    }

    public ImageIcon getDeleteEmployeeIcon() {
        return this.deleteEmployeeIcon;
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new FlowLayout(0));
        headerPanel.add(new JLabel("Planning window start:"));
        this.planningWindowStartField = new JTextField(10);
        this.planningWindowStartField.setEditable(false);
        headerPanel.add(this.planningWindowStartField);
        this.advancePlanningWindowStartButton = new JButton("Advance 1 day into the future");
        this.advancePlanningWindowStartButton.setEnabled(false);
        this.advancePlanningWindowStartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NurseRosteringPanel.this.advancePlanningWindowStart();
            }
        });
        headerPanel.add(this.advancePlanningWindowStartButton);
        return headerPanel;
    }

    private void createEmployeeListPanel() {
        this.employeeListPanel = new JPanel();
        this.employeeListPanel.setLayout(new BoxLayout(this.employeeListPanel, 1));
        this.unassignedPanel = new EmployeePanel(this, Collections.<ShiftDate>emptyList(), Collections.<Shift>emptyList(), null);
        this.employeeListPanel.add(this.unassignedPanel);
        this.employeeToPanelMap = new LinkedHashMap<Employee, EmployeePanel>();
        this.employeeToPanelMap.put(null, this.unassignedPanel);
        this.shiftAssignmentToPanelMap = new LinkedHashMap<ShiftAssignment, EmployeePanel>();
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public NurseRoster getNurseRoster() {
        return (NurseRoster)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        NurseRoster nurseRoster = (NurseRoster)solution;
        for (EmployeePanel employeePanel : this.employeeToPanelMap.values()) {
            if (employeePanel.getEmployee() == null) continue;
            this.employeeListPanel.remove(employeePanel);
        }
        this.employeeToPanelMap.clear();
        this.employeeToPanelMap.put(null, this.unassignedPanel);
        this.shiftAssignmentToPanelMap.clear();
        this.unassignedPanel.clearShiftAssignments();
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        List<Shift> shiftList = nurseRoster.getShiftList();
        this.unassignedPanel.setShiftDateListAndShiftList(shiftDateList, shiftList);
        this.updatePanel(nurseRoster);
        this.advancePlanningWindowStartButton.setEnabled(true);
        this.planningWindowStartField.setText(nurseRoster.getNurseRosterInfo().getPlanningWindowStart().getLabel());
    }

    @Override
    public void updatePanel(Solution solution) {
        EmployeePanel deadEmployeePanel;
        NurseRoster nurseRoster = (NurseRoster)solution;
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        List<Shift> shiftList = nurseRoster.getShiftList();
        LinkedHashSet<Employee> deadEmployeeSet = new LinkedHashSet<Employee>(this.employeeToPanelMap.keySet());
        deadEmployeeSet.remove(null);
        for (Employee employee : nurseRoster.getEmployeeList()) {
            deadEmployeeSet.remove(employee);
            EmployeePanel employeePanel = this.employeeToPanelMap.get(employee);
            if (employeePanel != null) continue;
            employeePanel = new EmployeePanel(this, shiftDateList, shiftList, employee);
            this.employeeListPanel.add(employeePanel);
            this.employeeToPanelMap.put(employee, employeePanel);
        }
        LinkedHashSet<ShiftAssignment> deadShiftAssignmentSet = new LinkedHashSet<ShiftAssignment>(this.shiftAssignmentToPanelMap.keySet());
        for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
            deadShiftAssignmentSet.remove(shiftAssignment);
            EmployeePanel employeePanel = this.shiftAssignmentToPanelMap.get(shiftAssignment);
            Employee employee = shiftAssignment.getEmployee();
            if (employeePanel != null && !ObjectUtils.equals((Object)employeePanel.getEmployee(), (Object)employee)) {
                this.shiftAssignmentToPanelMap.remove(shiftAssignment);
                employeePanel.removeShiftAssignment(shiftAssignment);
                employeePanel = null;
            }
            if (employeePanel != null) continue;
            employeePanel = this.employeeToPanelMap.get(employee);
            employeePanel.addShiftAssignment(shiftAssignment);
            this.shiftAssignmentToPanelMap.put(shiftAssignment, employeePanel);
        }
        for (ShiftAssignment deadShiftAssignment : deadShiftAssignmentSet) {
            deadEmployeePanel = this.shiftAssignmentToPanelMap.remove(deadShiftAssignment);
            deadEmployeePanel.removeShiftAssignment(deadShiftAssignment);
        }
        for (Employee deadEmployee : deadEmployeeSet) {
            deadEmployeePanel = this.employeeToPanelMap.remove(deadEmployee);
            this.employeeListPanel.remove(deadEmployeePanel);
        }
        for (EmployeePanel employeePanel : this.employeeToPanelMap.values()) {
            employeePanel.update();
        }
    }

    private void advancePlanningWindowStart() {
        this.logger.info("Advancing planningWindowStart.");
        if (this.solutionBusiness.isSolving()) {
            JOptionPane.showMessageDialog(this, "The GUI does not support this action yet during solving.\nPlanner itself does support it.", "Unsupported in GUI", 0);
            return;
        }
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            @Override
            public void doChange(ScoreDirector scoreDirector) {
                ShiftDate planningWindowStart;
                NurseRoster nurseRoster = (NurseRoster)scoreDirector.getWorkingSolution();
                NurseRosterInfo nurseRosterInfo = nurseRoster.getNurseRosterInfo();
                List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
                int windowStartIndex = shiftDateList.indexOf(planningWindowStart = nurseRosterInfo.getPlanningWindowStart());
                if (windowStartIndex < 0) {
                    throw new IllegalStateException("The planningWindowStart (" + planningWindowStart + ") must be in the shiftDateList (" + shiftDateList + ").");
                }
                ShiftDate oldLastShiftDate = shiftDateList.get(shiftDateList.size() - 1);
                ShiftDate newShiftDate = new ShiftDate();
                newShiftDate.setId(oldLastShiftDate.getId() + 1L);
                newShiftDate.setDayIndex(oldLastShiftDate.getDayIndex() + 1);
                newShiftDate.setDateString(oldLastShiftDate.determineNextDateString());
                newShiftDate.setDayOfWeek(oldLastShiftDate.getDayOfWeek().determineNextDayOfWeek());
                List<Shift> refShiftList = planningWindowStart.getShiftList();
                ArrayList<Shift> newShiftList = new ArrayList<Shift>(refShiftList.size());
                newShiftDate.setShiftList(newShiftList);
                nurseRoster.getShiftDateList().add(newShiftDate);
                scoreDirector.afterProblemFactAdded(newShiftDate);
                Shift oldLastShift = nurseRoster.getShiftList().get(nurseRoster.getShiftList().size() - 1);
                long shiftId = oldLastShift.getId() + 1L;
                int shiftIndex = oldLastShift.getIndex() + 1;
                long shiftAssignmentId = nurseRoster.getShiftAssignmentList().get(nurseRoster.getShiftAssignmentList().size() - 1).getId() + 1L;
                for (Shift refShift : refShiftList) {
                    Shift newShift = new Shift();
                    newShift.setId(shiftId);
                    ++shiftId;
                    newShift.setShiftDate(newShiftDate);
                    newShift.setShiftType(refShift.getShiftType());
                    newShift.setIndex(shiftIndex);
                    ++shiftIndex;
                    newShift.setRequiredEmployeeSize(refShift.getRequiredEmployeeSize());
                    newShiftList.add(newShift);
                    nurseRoster.getShiftList().add(newShift);
                    scoreDirector.afterProblemFactAdded(newShift);
                    for (int indexInShift = 0; indexInShift < newShift.getRequiredEmployeeSize(); ++indexInShift) {
                        ShiftAssignment newShiftAssignment = new ShiftAssignment();
                        newShiftAssignment.setId(shiftAssignmentId);
                        ++shiftAssignmentId;
                        newShiftAssignment.setShift(newShift);
                        newShiftAssignment.setIndexInShift(indexInShift);
                        nurseRoster.getShiftAssignmentList().add(newShiftAssignment);
                        scoreDirector.afterEntityAdded(newShiftAssignment);
                    }
                }
                ShiftDate newPlanningWindowStart = shiftDateList.get(++windowStartIndex);
                nurseRosterInfo.setPlanningWindowStart(newPlanningWindowStart);
                nurseRosterInfo.setLastShiftDate(newShiftDate);
                scoreDirector.afterProblemFactChanged(nurseRosterInfo);
            }
        });
        this.resetPanel(this.solutionBusiness.getSolution());
        this.validate();
    }

    public void deleteEmployee(final Employee employee) {
        this.logger.info("Scheduling delete of employee ({}).", (Object)employee);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            @Override
            public void doChange(ScoreDirector scoreDirector) {
                NurseRoster nurseRoster = (NurseRoster)scoreDirector.getWorkingSolution();
                for (ShiftAssignment shiftAssignment : nurseRoster.getShiftAssignmentList()) {
                    if (!ObjectUtils.equals((Object)shiftAssignment.getEmployee(), (Object)employee)) continue;
                    scoreDirector.beforeEntityRemoved(shiftAssignment);
                    shiftAssignment.setEmployee(null);
                    scoreDirector.afterEntityRemoved(shiftAssignment);
                }
                Iterator<Employee> it = nurseRoster.getEmployeeList().iterator();
                while (it.hasNext()) {
                    Employee workingEmployee = it.next();
                    if (!ObjectUtils.equals((Object)workingEmployee, (Object)employee)) continue;
                    scoreDirector.beforeProblemFactRemoved(workingEmployee);
                    it.remove();
                    scoreDirector.beforeProblemFactRemoved(employee);
                    break;
                }
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }

    public void moveShiftAssignmentToEmployee(ShiftAssignment shiftAssignment, Employee toEmployee) {
        this.solutionBusiness.doChangeMove(shiftAssignment, "employee", toEmployee);
        this.solverAndPersistenceFrame.resetScreen();
    }
}

