/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.pas.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.pas.domain.AdmissionPart;
import org.optaplanner.examples.pas.domain.Bed;
import org.optaplanner.examples.pas.domain.Department;
import org.optaplanner.examples.pas.domain.Equipment;
import org.optaplanner.examples.pas.domain.Gender;
import org.optaplanner.examples.pas.domain.GenderLimitation;
import org.optaplanner.examples.pas.domain.Patient;
import org.optaplanner.examples.pas.domain.PreferredPatientEquipment;
import org.optaplanner.examples.pas.domain.RequiredPatientEquipment;
import org.optaplanner.examples.pas.domain.RoomEquipment;
import org.optaplanner.examples.pas.domain.RoomSpecialism;

@XStreamAlias(value="Room")
public class Room
extends AbstractPersistable {
    private String name;
    private Department department;
    private int capacity;
    private GenderLimitation genderLimitation;
    private List<RoomSpecialism> roomSpecialismList;
    private List<RoomEquipment> roomEquipmentList;
    private List<Bed> bedList;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public GenderLimitation getGenderLimitation() {
        return this.genderLimitation;
    }

    public void setGenderLimitation(GenderLimitation genderLimitation) {
        this.genderLimitation = genderLimitation;
    }

    public List<RoomSpecialism> getRoomSpecialismList() {
        return this.roomSpecialismList;
    }

    public void setRoomSpecialismList(List<RoomSpecialism> roomSpecialismList) {
        this.roomSpecialismList = roomSpecialismList;
    }

    public List<RoomEquipment> getRoomEquipmentList() {
        return this.roomEquipmentList;
    }

    public void setRoomEquipmentList(List<RoomEquipment> roomEquipmentList) {
        this.roomEquipmentList = roomEquipmentList;
    }

    public List<Bed> getBedList() {
        return this.bedList;
    }

    public void setBedList(List<Bed> bedList) {
        this.bedList = bedList;
    }

    public String getLabel() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.department + "_" + this.name;
    }

    public int countHardDisallowedAdmissionPart(AdmissionPart admissionPart) {
        return this.countMissingRequiredRoomProperties(admissionPart.getPatient()) + this.department.countHardDisallowedAdmissionPart(admissionPart) + this.countDisallowedPatientGender(admissionPart.getPatient());
    }

    public int countMissingRequiredRoomProperties(Patient patient) {
        int count = 0;
        for (RequiredPatientEquipment requiredPatientEquipment : patient.getRequiredPatientEquipmentList()) {
            Equipment requiredEquipment = requiredPatientEquipment.getEquipment();
            boolean hasRequiredEquipment = false;
            for (RoomEquipment roomEquipment : this.roomEquipmentList) {
                if (!roomEquipment.getEquipment().equals(requiredEquipment)) continue;
                hasRequiredEquipment = true;
            }
            if (hasRequiredEquipment) continue;
            count += 100000;
        }
        return count;
    }

    public int countDisallowedPatientGender(Patient patient) {
        switch (this.genderLimitation) {
            case ANY_GENDER: {
                return 0;
            }
            case MALE_ONLY: {
                return patient.getGender() == Gender.MALE ? 0 : 4;
            }
            case FEMALE_ONLY: {
                return patient.getGender() == Gender.FEMALE ? 0 : 4;
            }
            case SAME_GENDER: {
                return 1;
            }
        }
        throw new IllegalStateException("The genderLimitation (" + (Object)((Object)this.genderLimitation) + ") is not implemented.");
    }

    public int countSoftDisallowedAdmissionPart(AdmissionPart admissionPart) {
        return this.countMissingPreferredRoomProperties(admissionPart.getPatient());
    }

    public int countMissingPreferredRoomProperties(Patient patient) {
        int count = 0;
        for (PreferredPatientEquipment preferredPatientEquipment : patient.getPreferredPatientEquipmentList()) {
            Equipment preferredEquipment = preferredPatientEquipment.getEquipment();
            boolean hasPreferredEquipment = false;
            for (RoomEquipment roomEquipment : this.roomEquipmentList) {
                if (!roomEquipment.getEquipment().equals(preferredEquipment)) continue;
                hasPreferredEquipment = true;
            }
            if (hasPreferredEquipment) continue;
            count += 20;
        }
        return count;
    }
}

