/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.util.UUID;
import org.drools.core.RuleBase;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.reteoo.ReteooRuleBase;

public class RuleBaseFactory {
    private static final RuleBaseFactory INSTANCE = new RuleBaseFactory();

    private RuleBaseFactory() {
    }

    public static RuleBaseFactory getInstance() {
        return INSTANCE;
    }

    public static RuleBase newRuleBase() {
        return RuleBaseFactory.newRuleBase(1, null);
    }

    public static RuleBase newRuleBase(String rulebaseId) {
        return RuleBaseFactory.newRuleBase(rulebaseId, 1, null);
    }

    public static RuleBase newRuleBase(RuleBaseConfiguration config) {
        return RuleBaseFactory.newRuleBase(1, config);
    }

    public static RuleBase newRuleBase(String rulebaseId, RuleBaseConfiguration config) {
        return RuleBaseFactory.newRuleBase(rulebaseId, 1, config);
    }

    public static RuleBase newRuleBase(String rulebaseId, int type) {
        return RuleBaseFactory.newRuleBase(rulebaseId, type, null);
    }

    public static RuleBase newRuleBase(int type) {
        return RuleBaseFactory.newRuleBase(type, null);
    }

    public static RuleBase newRuleBase(int type, RuleBaseConfiguration config) {
        return RuleBaseFactory.newRuleBase(UUID.randomUUID().toString(), type, config);
    }

    public static RuleBase newRuleBase(String rulebaseId, int type, RuleBaseConfiguration config) {
        switch (type) {
            case 1: {
                return new ReteooRuleBase(rulebaseId, config);
            }
        }
        throw new IllegalArgumentException("Unknown engine type: " + type);
    }
}

