/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextFactory;
import org.drools.core.common.UpdateContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.AbstractTerminalNode;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.JoinNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RiaPathMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;

public class RightInputAdapterNode
extends ObjectSource
implements LeftTupleSinkNode,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    private LeftTupleSource tupleSource;
    private LeftTupleSource startTupleSource;
    private boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public RightInputAdapterNode() {
    }

    public RightInputAdapterNode(int id, LeftTupleSource source, LeftTupleSource startTupleSource, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.tupleSource = source;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
        this.startTupleSource = startTupleSource;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.startTupleSource = (LeftTupleSource)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
        out.writeObject(this.startTupleSource);
    }

    public LeftTupleSource getStartTupleSource() {
        return this.startTupleSource;
    }

    public void setStartTupleSource(LeftTupleSource startTupleSource) {
        this.startTupleSource = startTupleSource;
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        RiaNodeMemory rianMem = new RiaNodeMemory();
        RiaPathMemory pmem = new RiaPathMemory(this);
        AbstractTerminalNode.initPathMemory(pmem, this.getLeftTupleSource(), this.getStartTupleSource(), wm, null);
        rianMem.setRiaPathMemory(pmem);
        return rianMem;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        JoinNodeLeftTuple peer = new JoinNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    public InternalFactHandle createFactHandle(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Map map;
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = (ProtobufMessages.FactHandle)map.get(PersisterHelper.createTupleKey(leftTuple));
        }
        handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), leftTuple, _handle.getRecency(), workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), leftTuple), workingMemory, null) : workingMemory.getFactHandleFactory().newFactHandle(leftTuple, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), leftTuple), workingMemory, null);
        return handle;
    }

    @Override
    public void attach(BuildContext context) {
        this.tupleSource.addTupleSink(this, context);
        if (context == null || context.getRuleBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextFactory pctxFactory = ((InternalRuleBase)workingMemory.getRuleBase()).getConfiguration().getComponentFactory().getPropagationContextFactory();
            PropagationContext propagationContext = pctxFactory.createPropagationContext(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.tupleSource.networkUpdated(updateContext);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.tupleSource.removeTupleSink(this);
        }
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public short getType() {
        return 71;
    }

    @Override
    public int hashCode() {
        return this.tupleSource.hashCode() * 17 + (this.tupleMemoryEnabled ? 1234 : 4321);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof RightInputAdapterNode)) {
            return false;
        }
        RightInputAdapterNode other = (RightInputAdapterNode)object;
        return this.tupleMemoryEnabled == other.tupleMemoryEnabled && this.tupleSource.equals(other.tupleSource);
    }

    @Override
    public String toString() {
        return "RightInputAdapterNode(" + this.id + ")[ tupleMemoryEnabled=" + this.tupleMemoryEnabled + ", tupleSource=" + this.tupleSource + ", source=" + this.source + ", associations=" + this.associations.keySet() + ", partitionId=" + this.partitionId + "]";
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new JoinNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new JoinNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new JoinNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.tupleSource;
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLeftInferredMask() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should never be called");
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException();
    }

    public static class RiaNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private RiaPathMemory pathMemory;

        public RiaPathMemory getRiaPathMemory() {
            return this.pathMemory;
        }

        public void setRiaPathMemory(RiaPathMemory pathMemory) {
            this.pathMemory = pathMemory;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.pathMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.pathMemory.setSegmentMemory(segmentMemory);
        }

        @Override
        public short getNodeType() {
            return 71;
        }
    }
}

