/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.solver.move.ExaminationMoveHelper;

public class PeriodChangeMove
implements Move {
    private Exam exam;
    private Period toPeriod;

    public PeriodChangeMove(Exam exam, Period toPeriod) {
        this.exam = exam;
        this.toPeriod = toPeriod;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.exam.getPeriod(), (Object)this.toPeriod);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new PeriodChangeMove(this.exam, this.exam.getPeriod());
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        ExaminationMoveHelper.movePeriod(scoreDirector, this.exam, this.toPeriod);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.exam);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PeriodChangeMove) {
            PeriodChangeMove other = (PeriodChangeMove)o;
            return new EqualsBuilder().append((Object)this.exam, (Object)other.exam).append((Object)this.toPeriod, (Object)other.toPeriod).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.exam).append((Object)this.toPeriod).toHashCode();
    }

    public String toString() {
        return this.exam + " => " + this.toPeriod;
    }
}

