/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.domain.timewindowed;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.examples.vehiclerouting.domain.Customer;

@XStreamAlias(value="VrpTimeWindowedCustomer")
public class TimeWindowedCustomer
extends Customer {
    private int milliReadyTime;
    private int milliDueTime;
    private int milliServiceDuration;
    private Integer milliArrivalTime;

    public int getMilliReadyTime() {
        return this.milliReadyTime;
    }

    public void setMilliReadyTime(int milliReadyTime) {
        this.milliReadyTime = milliReadyTime;
    }

    public int getMilliDueTime() {
        return this.milliDueTime;
    }

    public void setMilliDueTime(int milliDueTime) {
        this.milliDueTime = milliDueTime;
    }

    public int getMilliServiceDuration() {
        return this.milliServiceDuration;
    }

    public void setMilliServiceDuration(int milliServiceDuration) {
        this.milliServiceDuration = milliServiceDuration;
    }

    public Integer getMilliArrivalTime() {
        return this.milliArrivalTime;
    }

    public void setMilliArrivalTime(Integer milliArrivalTime) {
        this.milliArrivalTime = milliArrivalTime;
    }

    public String getTimeWindowLabel() {
        return this.milliReadyTime + "-" + this.milliDueTime;
    }

    public Integer getDepartureTime() {
        if (this.milliArrivalTime == null) {
            return null;
        }
        return Math.max(this.milliArrivalTime, this.milliReadyTime) + this.milliServiceDuration;
    }

    public boolean isArrivalBeforeReadyTime() {
        return this.milliArrivalTime != null && this.milliArrivalTime < this.milliReadyTime;
    }

    public boolean isArrivalAfterDueTime() {
        return this.milliArrivalTime != null && this.milliDueTime < this.milliArrivalTime;
    }

    @Override
    public TimeWindowedCustomer getNextCustomer() {
        return (TimeWindowedCustomer)super.getNextCustomer();
    }
}

