/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.solver.score;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.director.simple.SimpleScoreCalculator;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Standstill;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;

public class VehicleRoutingSimpleScoreCalculator
implements SimpleScoreCalculator<VehicleRoutingSolution> {
    public HardSoftScore calculateScore(VehicleRoutingSolution schedule) {
        boolean timeWindowed = schedule instanceof TimeWindowedVehicleRoutingSolution;
        List<Customer> customerList = schedule.getCustomerList();
        List<Vehicle> vehicleList = schedule.getVehicleList();
        HashMap<Vehicle, Integer> vehicleDemandMap = new HashMap<Vehicle, Integer>(vehicleList.size());
        for (Vehicle vehicle : vehicleList) {
            vehicleDemandMap.put(vehicle, 0);
        }
        int hardScore = 0;
        int softScore = 0;
        for (Customer customer : customerList) {
            Integer milliArrivalTime;
            TimeWindowedCustomer timeWindowedCustomer;
            int milliDueTime;
            Standstill previousStandstill = customer.getPreviousStandstill();
            if (previousStandstill == null) continue;
            Vehicle vehicle = customer.getVehicle();
            vehicleDemandMap.put(vehicle, (Integer)vehicleDemandMap.get(vehicle) + customer.getDemand());
            softScore -= customer.getMilliDistanceToPreviousStandstill();
            if (customer.getNextCustomer() == null) {
                softScore -= vehicle.getLocation().getMilliDistance(customer.getLocation());
            }
            if (!timeWindowed || (milliDueTime = (timeWindowedCustomer = (TimeWindowedCustomer)customer).getMilliDueTime()) >= (milliArrivalTime = timeWindowedCustomer.getMilliArrivalTime())) continue;
            hardScore -= milliArrivalTime - milliDueTime;
        }
        for (Map.Entry entry : vehicleDemandMap.entrySet()) {
            int capacity = ((Vehicle)entry.getKey()).getCapacity();
            int demand = (Integer)entry.getValue();
            if (demand <= capacity) continue;
            hardScore -= demand - capacity;
        }
        return HardSoftScore.valueOf(hardScore, softScore);
    }
}

