/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.composite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.CompositeMoveSelector;
import org.optaplanner.core.impl.move.CompositeMove;
import org.optaplanner.core.impl.move.Move;
import org.optaplanner.core.impl.move.NoChangeMove;

public class CartesianProductMoveSelector
extends CompositeMoveSelector {
    private static final Move EMPTY_MARK = new NoChangeMove();
    private final boolean ignoreEmptyChildIterators;

    public CartesianProductMoveSelector(List<MoveSelector> childMoveSelectorList, boolean ignoreEmptyChildIterators, boolean randomSelection) {
        super(childMoveSelectorList, randomSelection);
        this.ignoreEmptyChildIterators = ignoreEmptyChildIterators;
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection) {
            return true;
        }
        return !this.childMoveSelectorList.isEmpty() && ((MoveSelector)this.childMoveSelectorList.get(this.childMoveSelectorList.size() - 1)).isNeverEnding();
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (MoveSelector moveSelector : this.childMoveSelectorList) {
            long childSize = moveSelector.getSize();
            if (childSize == 0L) {
                if (this.ignoreEmptyChildIterators) continue;
                return 0L;
            }
            if (size == 0L) {
                size = childSize;
                continue;
            }
            size *= childSize;
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return new OriginalCartesianProductMoveIterator();
        }
        return new RandomCartesianProductMoveIterator();
    }

    @Override
    public String toString() {
        return "CartesianProduct(" + this.childMoveSelectorList + ")";
    }

    public class RandomCartesianProductMoveIterator
    extends SelectionIterator<Move> {
        private List<Iterator<Move>> moveIteratorList;
        private Boolean empty;

        public RandomCartesianProductMoveIterator() {
            this.moveIteratorList = new ArrayList<Iterator<Move>>(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            this.empty = null;
            for (MoveSelector moveSelector : CartesianProductMoveSelector.this.childMoveSelectorList) {
                this.moveIteratorList.add(moveSelector.iterator());
            }
        }

        @Override
        public boolean hasNext() {
            if (this.empty == null) {
                int emptyCount = 0;
                for (Iterator<Move> moveIterator : this.moveIteratorList) {
                    if (moveIterator.hasNext()) continue;
                    ++emptyCount;
                    if (CartesianProductMoveSelector.this.ignoreEmptyChildIterators) continue;
                    break;
                }
                this.empty = CartesianProductMoveSelector.this.ignoreEmptyChildIterators ? emptyCount == this.moveIteratorList.size() : emptyCount > 0;
            }
            return this.empty == false;
        }

        @Override
        public Move next() {
            ArrayList<Move> moveList = new ArrayList<Move>(this.moveIteratorList.size());
            for (int i = 0; i < this.moveIteratorList.size(); ++i) {
                Iterator<Move> moveIterator = this.moveIteratorList.get(i);
                boolean skip = false;
                if (!moveIterator.hasNext()) {
                    MoveSelector moveSelector = (MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i);
                    moveIterator = moveSelector.iterator();
                    this.moveIteratorList.set(i, moveIterator);
                    if (!moveIterator.hasNext()) {
                        if (CartesianProductMoveSelector.this.ignoreEmptyChildIterators) {
                            skip = true;
                        } else {
                            throw new NoSuchElementException("The iterator of childMoveSelector (" + moveSelector + ") is empty.");
                        }
                    }
                }
                if (skip) continue;
                moveList.add(moveIterator.next());
            }
            if (CartesianProductMoveSelector.this.ignoreEmptyChildIterators) {
                if (moveList.isEmpty()) {
                    throw new NoSuchElementException("All iterators of childMoveSelectorList (" + CartesianProductMoveSelector.this.childMoveSelectorList + ") are empty.");
                }
                if (moveList.size() == 1) {
                    return (Move)moveList.get(0);
                }
            }
            return new CompositeMove(moveList);
        }
    }

    public class OriginalCartesianProductMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private List<Iterator<Move>> moveIteratorList;
        private List<Move> subSelections;

        public OriginalCartesianProductMoveIterator() {
            this.moveIteratorList = new ArrayList<Iterator<Move>>(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            for (int i = 0; i < CartesianProductMoveSelector.this.childMoveSelectorList.size(); ++i) {
                this.moveIteratorList.add(null);
            }
            this.subSelections = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected Move createUpcomingSelection() {
            ArrayList<Object> moveList;
            int startingIndex;
            if (this.subSelections == null) {
                startingIndex = -1;
                moveList = new ArrayList(CartesianProductMoveSelector.this.childMoveSelectorList.size());
            } else {
                Iterator<Move> moveIterator;
                for (startingIndex = this.moveIteratorList.size() - 1; startingIndex >= 0 && !(moveIterator = this.moveIteratorList.get(startingIndex)).hasNext(); --startingIndex) {
                }
                if (startingIndex < 0) {
                    return (Move)this.noUpcomingSelection();
                }
                moveList = new ArrayList<Move>(this.subSelections.subList(0, startingIndex));
                moveList.add(this.moveIteratorList.get(startingIndex).next());
            }
            for (int i = startingIndex + 1; i < this.moveIteratorList.size(); ++i) {
                Move next;
                Iterator moveIterator = ((MoveSelector)CartesianProductMoveSelector.this.childMoveSelectorList.get(i)).iterator();
                this.moveIteratorList.set(i, moveIterator);
                if (!moveIterator.hasNext()) {
                    if (!CartesianProductMoveSelector.this.ignoreEmptyChildIterators) return (Move)this.noUpcomingSelection();
                    next = EMPTY_MARK;
                } else {
                    next = (Move)moveIterator.next();
                }
                moveList.add(next);
            }
            this.subSelections = moveList;
            if (!CartesianProductMoveSelector.this.ignoreEmptyChildIterators) return new CompositeMove(moveList);
            moveList = new ArrayList<Object>(moveList);
            Iterator it = moveList.iterator();
            while (it.hasNext()) {
                Move move = (Move)it.next();
                if (move != EMPTY_MARK) continue;
                it.remove();
            }
            if (moveList.isEmpty()) {
                return (Move)this.noUpcomingSelection();
            }
            if (moveList.size() != 1) return new CompositeMove(moveList);
            return (Move)moveList.get(0);
        }
    }
}

