/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.buildin.hardsoft;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScoreHolder;
import org.optaplanner.core.api.score.holder.ScoreHolder;
import org.optaplanner.core.impl.score.definition.AbstractScoreDefinition;

public class HardSoftScoreDefinition
extends AbstractScoreDefinition<HardSoftScore> {
    private double hardScoreTimeGradientWeight = 0.75;
    private HardSoftScore perfectMaximumScore = HardSoftScore.valueOf(0, 0);
    private HardSoftScore perfectMinimumScore = HardSoftScore.valueOf(Integer.MIN_VALUE, Integer.MIN_VALUE);

    public double getHardScoreTimeGradientWeight() {
        return this.hardScoreTimeGradientWeight;
    }

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    @Override
    public HardSoftScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    public void setPerfectMaximumScore(HardSoftScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    @Override
    public HardSoftScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    public void setPerfectMinimumScore(HardSoftScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public Class<HardSoftScore> getScoreClass() {
        return HardSoftScore.class;
    }

    @Override
    public Score parseScore(String scoreString) {
        return HardSoftScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardSoftScore startScore, HardSoftScore endScore, HardSoftScore score) {
        if (score.compareTo(endScore) > 0) {
            return 1.0;
        }
        if (score.compareTo(startScore) < 0) {
            return 0.0;
        }
        double timeGradient = 0.0;
        double softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
        if (startScore.getHardScore() == endScore.getHardScore()) {
            timeGradient += this.hardScoreTimeGradientWeight;
        } else {
            int hardScoreTotal = endScore.getHardScore() - startScore.getHardScore();
            int hardScoreDelta = score.getHardScore() - startScore.getHardScore();
            double hardTimeGradient = (double)hardScoreDelta / (double)hardScoreTotal;
            timeGradient += hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore() >= endScore.getSoftScore()) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (score.getSoftScore() > startScore.getSoftScore()) {
            int softScoreTotal = endScore.getSoftScore() - startScore.getSoftScore();
            int softScoreDelta = score.getSoftScore() - startScore.getSoftScore();
            double softTimeGradient = (double)softScoreDelta / (double)softScoreTotal;
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public ScoreHolder buildScoreHolder(boolean constraintMatchEnabled) {
        return new HardSoftScoreHolder(constraintMatchEnabled);
    }
}

