/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.reteoo.KieComponentFactory;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.Query;
import org.drools.core.rule.Rule;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.RuleComponent;
import org.drools.core.time.TemporalDependencyMatrix;

public class BuildContext {
    private LeftTupleSource tupleSource;
    private ObjectSource objectSource;
    private LinkedList<Pattern> objectType;
    private int currentPatternOffset;
    private InternalRuleBase rulebase;
    private Rule rule;
    private GroupElement subRule;
    private Stack<RuleComponent> ruleComponent;
    private InternalWorkingMemory[] workingMemories;
    private ReteooBuilder.IdGenerator idGenerator;
    private LinkedList<RuleConditionElement> buildstack;
    private List<BetaNodeFieldConstraint> betaconstraints;
    private List<AlphaNodeFieldConstraint> alphaConstraints;
    private EntryPointId currentEntryPoint;
    private boolean tupleMemoryEnabled;
    private boolean objectTypeNodeMemoryEnabled;
    private boolean query;
    private List<BaseNode> nodes;
    private RuleBasePartitionId partitionId;
    private TemporalDependencyMatrix temporal;
    private ObjectTypeNode rootObjectTypeNode;
    private Pattern[] lastBuiltPatterns;
    private boolean emptyForAllBetaConstraints;
    private KieComponentFactory componentFactory;
    private boolean attachPQN;

    public BuildContext(InternalRuleBase rulebase, ReteooBuilder.IdGenerator idGenerator) {
        this.rulebase = rulebase;
        this.idGenerator = idGenerator;
        this.workingMemories = null;
        this.objectType = null;
        this.buildstack = null;
        this.tupleSource = null;
        this.objectSource = null;
        this.currentPatternOffset = 0;
        this.tupleMemoryEnabled = true;
        this.objectTypeNodeMemoryEnabled = true;
        this.currentEntryPoint = EntryPointId.DEFAULT;
        this.nodes = new LinkedList<BaseNode>();
        this.partitionId = null;
        this.ruleComponent = new Stack();
        this.attachPQN = true;
        this.componentFactory = rulebase.getConfiguration().getComponentFactory();
        this.emptyForAllBetaConstraints = false;
    }

    public boolean isEmptyForAllBetaConstraints() {
        return this.emptyForAllBetaConstraints;
    }

    public void setEmptyForAllBetaConstraints(boolean emptyForAllBetaConstraints) {
        this.emptyForAllBetaConstraints = emptyForAllBetaConstraints;
    }

    public int getCurrentPatternOffset() {
        return this.currentPatternOffset;
    }

    public void setCurrentPatternOffset(int currentPatternIndex) {
        this.currentPatternOffset = currentPatternIndex;
        this.syncObjectTypesWithPatternOffset();
    }

    public void syncObjectTypesWithPatternOffset() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        while (this.objectType.size() > this.currentPatternOffset) {
            this.objectType.removeLast();
        }
    }

    public ObjectSource getObjectSource() {
        return this.objectSource;
    }

    public void setObjectSource(ObjectSource objectSource) {
        this.objectSource = objectSource;
    }

    public LinkedList<Pattern> getObjectType() {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        return this.objectType;
    }

    public void setObjectType(LinkedList<Pattern> objectType) {
        if (this.objectType == null) {
            this.objectType = new LinkedList();
        }
        this.objectType = objectType;
    }

    public LeftTupleSource getTupleSource() {
        return this.tupleSource;
    }

    public void setTupleSource(LeftTupleSource tupleSource) {
        this.tupleSource = tupleSource;
    }

    public void incrementCurrentPatternOffset() {
        ++this.currentPatternOffset;
    }

    public void decrementCurrentPatternOffset() {
        --this.currentPatternOffset;
        this.syncObjectTypesWithPatternOffset();
    }

    public InternalRuleBase getRuleBase() {
        return this.rulebase;
    }

    public InternalWorkingMemory[] getWorkingMemories() {
        if (this.workingMemories == null) {
            this.workingMemories = this.rulebase.getWorkingMemories();
        }
        return this.workingMemories;
    }

    public int getNextId() {
        return this.idGenerator.getNextId();
    }

    public void releaseId(int id) {
        this.idGenerator.releaseId(id);
    }

    public void push(RuleConditionElement rce) {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        this.buildstack.addLast(rce);
    }

    public RuleConditionElement pop() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.removeLast();
    }

    public RuleConditionElement peek() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.getLast();
    }

    public ListIterator<RuleConditionElement> stackIterator() {
        if (this.buildstack == null) {
            this.buildstack = new LinkedList();
        }
        return this.buildstack.listIterator(this.buildstack.size());
    }

    public List<BetaNodeFieldConstraint> getBetaconstraints() {
        return this.betaconstraints;
    }

    public void setBetaconstraints(List<BetaNodeFieldConstraint> betaconstraints) {
        this.betaconstraints = betaconstraints;
    }

    public List<AlphaNodeFieldConstraint> getAlphaConstraints() {
        return this.alphaConstraints;
    }

    public void setAlphaConstraints(List<AlphaNodeFieldConstraint> alphaConstraints) {
        this.alphaConstraints = alphaConstraints;
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean hasLeftMemory) {
        this.tupleMemoryEnabled = hasLeftMemory;
    }

    public boolean isObjectTypeNodeMemoryEnabled() {
        return this.objectTypeNodeMemoryEnabled;
    }

    public void setObjectTypeNodeMemoryEnabled(boolean hasObjectTypeMemory) {
        this.objectTypeNodeMemoryEnabled = hasObjectTypeMemory;
    }

    public boolean isQuery() {
        return this.query;
    }

    public EntryPointId getCurrentEntryPoint() {
        return this.currentEntryPoint;
    }

    public void setCurrentEntryPoint(EntryPointId currentEntryPoint) {
        this.currentEntryPoint = currentEntryPoint;
    }

    public List<BaseNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<BaseNode> nodes) {
        this.nodes = nodes;
    }

    public RuleBasePartitionId getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(RuleBasePartitionId partitionId) {
        this.partitionId = partitionId;
    }

    public boolean isStreamMode() {
        return this.temporal != null;
    }

    public TemporalDependencyMatrix getTemporalDistance() {
        return this.temporal;
    }

    public void setTemporalDistance(TemporalDependencyMatrix temporal) {
        this.temporal = temporal;
    }

    public LinkedList<RuleConditionElement> getBuildStack() {
        return this.buildstack;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
        if (rule instanceof Query) {
            this.query = true;
        }
    }

    public GroupElement getSubRule() {
        return this.subRule;
    }

    public void setSubRule(GroupElement subRule) {
        this.subRule = subRule;
    }

    public RuleComponent popRuleComponent() {
        return this.ruleComponent.pop();
    }

    public RuleComponent peekRuleComponent() {
        return this.ruleComponent.isEmpty() ? null : this.ruleComponent.peek();
    }

    public void pushRuleComponent(RuleComponent ruleComponent) {
        this.ruleComponent.push(ruleComponent);
    }

    public ObjectTypeNode getRootObjectTypeNode() {
        return this.rootObjectTypeNode;
    }

    public void setRootObjectTypeNode(ObjectTypeNode source) {
        this.rootObjectTypeNode = source;
    }

    public Pattern[] getLastBuiltPatterns() {
        return this.lastBuiltPatterns;
    }

    public void setLastBuiltPattern(Pattern lastBuiltPattern) {
        if (this.lastBuiltPatterns == null) {
            this.lastBuiltPatterns = new Pattern[]{lastBuiltPattern, null};
        } else {
            this.lastBuiltPatterns[1] = this.lastBuiltPatterns[0];
            this.lastBuiltPatterns[0] = lastBuiltPattern;
        }
    }

    public boolean isAttachPQN() {
        return this.attachPQN;
    }

    public void setAttachPQN(boolean attachPQN) {
        this.attachPQN = attachPQN;
    }

    public KieComponentFactory getComponentFactory() {
        return this.componentFactory;
    }

    public void setComponentFactory(KieComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }
}

