/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.optaplanner.benchmark.impl.aggregator.swingui.MixedCheckBox;

public class CheckBoxTree
extends JTree {
    private static final Color TREE_SELECTION_COLOR = UIManager.getColor("Tree.selectionBackground");

    public CheckBoxTree(DefaultMutableTreeNode root) {
        super(root);
        this.addMouseListener(new CheckBoxTreeMouseListener(this));
        this.setCellRenderer(new CheckBoxTreeCellRenderer());
        this.setToggleClickCount(0);
        this.getSelectionModel().setSelectionMode(1);
    }

    public void expandAllNodes() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    public void collapseAllNodes() {
        for (int i = this.getRowCount() - 1; i > 0; --i) {
            this.collapseRow(i);
        }
    }

    private static class CheckBoxTreeCellRenderer
    implements TreeCellRenderer {
        private CheckBoxTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            MixedCheckBox checkBox = (MixedCheckBox)node.getUserObject();
            checkBox.setBackground(selected ? TREE_SELECTION_COLOR : Color.WHITE);
            return checkBox;
        }
    }

    private static class CheckBoxTreeMouseListener
    extends MouseAdapter {
        private CheckBoxTree tree;
        private double unlabeledMixedCheckBoxWidth;

        public CheckBoxTreeMouseListener(CheckBoxTree tree) {
            this.tree = tree;
            this.unlabeledMixedCheckBoxWidth = new MixedCheckBox().getPreferredSize().getWidth();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath path = this.tree.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                MixedCheckBox checkBox = (MixedCheckBox)currentNode.getUserObject();
                if ((double)e.getX() - this.tree.getPathBounds(path).getX() > this.unlabeledMixedCheckBoxWidth) {
                    return;
                }
                block0 : switch (checkBox.getStatus()) {
                    case CHECKED: {
                        checkBox.setStatus(MixedCheckBox.MixedCheckBoxStatus.UNCHECKED);
                        this.selectChildren(currentNode, MixedCheckBox.MixedCheckBoxStatus.UNCHECKED);
                        TreeNode[] ancestorNodes = currentNode.getPath();
                        for (int i = ancestorNodes.length - 2; i >= 0; --i) {
                            DefaultMutableTreeNode ancestorNode = (DefaultMutableTreeNode)ancestorNodes[i];
                            MixedCheckBox ancestorCheckbox = (MixedCheckBox)ancestorNode.getUserObject();
                            if (this.checkChildren(ancestorNode, MixedCheckBox.MixedCheckBoxStatus.UNCHECKED)) {
                                ancestorCheckbox.setStatus(MixedCheckBox.MixedCheckBoxStatus.UNCHECKED);
                                continue;
                            }
                            ancestorCheckbox.setStatus(MixedCheckBox.MixedCheckBoxStatus.MIXED);
                        }
                        break;
                    }
                    case UNCHECKED: {
                        checkBox.setStatus(MixedCheckBox.MixedCheckBoxStatus.CHECKED);
                        this.selectChildren(currentNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED);
                        TreeNode[] ancestorNodes = currentNode.getPath();
                        for (int i = ancestorNodes.length - 2; i >= 0; --i) {
                            DefaultMutableTreeNode ancestorNode = (DefaultMutableTreeNode)ancestorNodes[i];
                            MixedCheckBox ancestorCheckbox = (MixedCheckBox)ancestorNode.getUserObject();
                            if (this.checkChildren(ancestorNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED)) {
                                ancestorCheckbox.setStatus(MixedCheckBox.MixedCheckBoxStatus.CHECKED);
                                continue;
                            }
                            ancestorCheckbox.setStatus(MixedCheckBox.MixedCheckBoxStatus.MIXED);
                        }
                        break;
                    }
                    case MIXED: {
                        checkBox.setStatus(MixedCheckBox.MixedCheckBoxStatus.CHECKED);
                        this.selectChildren(currentNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED);
                        TreeNode[] ancestorNodes = currentNode.getPath();
                        for (int i = ancestorNodes.length - 2; i >= 0; --i) {
                            DefaultMutableTreeNode ancestorNode = (DefaultMutableTreeNode)ancestorNodes[i];
                            MixedCheckBox ancestorCheckbox = (MixedCheckBox)ancestorNode.getUserObject();
                            if (!this.checkChildren(ancestorNode, MixedCheckBox.MixedCheckBoxStatus.CHECKED)) break block0;
                            ancestorCheckbox.setStatus(MixedCheckBox.MixedCheckBoxStatus.CHECKED);
                        }
                        break;
                    }
                }
                this.tree.treeDidChange();
            }
        }

        private void selectChildren(DefaultMutableTreeNode parent, MixedCheckBox.MixedCheckBoxStatus status) {
            Enumeration<TreeNode> children = parent.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                MixedCheckBox checkBox = (MixedCheckBox)child.getUserObject();
                checkBox.setStatus(status);
                this.selectChildren(child, status);
            }
        }

        private boolean checkChildren(DefaultMutableTreeNode parent, MixedCheckBox.MixedCheckBoxStatus status) {
            boolean childrenCheck = true;
            Enumeration<TreeNode> children = parent.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                MixedCheckBox checkBox = (MixedCheckBox)child.getUserObject();
                if (checkBox.getStatus() == status) continue;
                childrenCheck = false;
                break;
            }
            return childrenCheck;
        }
    }
}

