/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.common.AbstractWorkingMemory;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.Scheduler;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufOutputMarshaller;
import org.drools.core.marshalling.impl.RuleBaseNodes;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.phreak.PhreakTimerNode;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.GlobalResolver;
import org.kie.api.KieBase;
import org.kie.api.marshalling.Marshaller;
import org.kie.api.marshalling.MarshallingConfiguration;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class ProtobufMarshaller
implements Marshaller {
    public static final Map<Integer, TimersInputMarshaller> TIMER_READERS = new HashMap<Integer, TimersInputMarshaller>();
    KieBase kbase;
    GlobalResolver globalResolver;
    RuleBaseConfiguration ruleBaseConfig;
    MarshallingConfiguration marshallingConfig;
    ObjectMarshallingStrategyStore strategyStore;

    public ProtobufMarshaller(KieBase kbase, MarshallingConfiguration marshallingConfig) {
        this.kbase = kbase;
        this.ruleBaseConfig = this.ruleBaseConfig != null ? this.ruleBaseConfig : RuleBaseConfiguration.getDefaultInstance();
        this.marshallingConfig = marshallingConfig;
        this.strategyStore = this.marshallingConfig.getObjectMarshallingStrategyStore();
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream) throws IOException, ClassNotFoundException {
        return this.unmarshall(stream, null, null);
    }

    public StatefulKnowledgeSession unmarshall(InputStream stream, KieSessionConfiguration config, Environment environment) throws IOException, ClassNotFoundException {
        if (config == null) {
            config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        }
        if (environment == null) {
            environment = KnowledgeBaseFactory.newEnvironment();
        }
        MarshallerReaderContext context = new MarshallerReaderContext(stream, (InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase, RuleBaseNodes.getNodeMap((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase), this.strategyStore, TIMER_READERS, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), environment);
        int id = ((ReteooRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).nextWorkingMemoryCounter();
        RuleBaseConfiguration conf = ((ReteooRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration();
        AbstractWorkingMemory session = ProtobufInputMarshaller.readSession(context, id, environment, (SessionConfiguration)config);
        context.close();
        if (((SessionConfiguration)config).isKeepReference()) {
            ((ReteooRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).addStatefulSession(session);
        }
        return (StatefulKnowledgeSession)session.getKnowledgeRuntime();
    }

    public void unmarshall(InputStream stream, KieSession ksession) throws IOException, ClassNotFoundException {
        MarshallerReaderContext context = new MarshallerReaderContext(stream, (InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase, RuleBaseNodes.getNodeMap((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase), this.strategyStore, TIMER_READERS, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        ProtobufInputMarshaller.readSession((AbstractWorkingMemory)((StatefulKnowledgeSessionImpl)ksession).session, context);
        context.close();
    }

    public void marshall(OutputStream stream, KieSession ksession) throws IOException {
        this.marshall(stream, ksession, ksession.getSessionClock().getCurrentTime());
    }

    public void marshall(OutputStream stream, KieSession ksession, long clockTime) throws IOException {
        MarshallerWriteContext context = new MarshallerWriteContext(stream, (InternalRuleBase)((InternalKnowledgeBase)this.kbase).getRuleBase(), ((StatefulKnowledgeSessionImpl)ksession).session, RuleBaseNodes.getNodeMap((InternalRuleBase)((InternalKnowledgeBase)this.kbase).getRuleBase()), this.strategyStore, this.marshallingConfig.isMarshallProcessInstances(), this.marshallingConfig.isMarshallWorkItems(), ksession.getEnvironment());
        context.clockTime = clockTime;
        ProtobufOutputMarshaller.writeSession(context);
        context.close();
    }

    public MarshallingConfiguration getMarshallingConfiguration() {
        return this.marshallingConfig;
    }

    static {
        TIMER_READERS.put(3, new SlidingTimeWindow.BehaviorJobContextTimerInputMarshaller());
        TIMER_READERS.put(2, new Scheduler.ActivationTimerInputMarshaller());
        TIMER_READERS.put(1, new ObjectTypeNode.ExpireJobContextTimerInputMarshaller());
        TIMER_READERS.put(5, new PhreakTimerNode.TimerNodeTimerInputMarshaller());
    }
}

