/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.constructionheuristic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.optaplanner.core.config.constructionheuristic.decider.forager.ConstructionHeuristicForagerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.EntityPlacerConfig;
import org.optaplanner.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.constructionheuristic.ConstructionHeuristicSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.DefaultConstructionHeuristicSolverPhase;
import org.optaplanner.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import org.optaplanner.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import org.optaplanner.core.impl.constructionheuristic.placer.EntityPlacer;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="constructionHeuristic")
public class ConstructionHeuristicSolverPhaseConfig
extends SolverPhaseConfig {
    protected ConstructionHeuristicType constructionHeuristicType = null;
    @XStreamImplicit
    protected List<EntityPlacerConfig> entityPlacerConfigList = null;
    @XStreamAlias(value="forager")
    protected ConstructionHeuristicForagerConfig foragerConfig = null;

    public ConstructionHeuristicType getConstructionHeuristicType() {
        return this.constructionHeuristicType;
    }

    public void setConstructionHeuristicType(ConstructionHeuristicType constructionHeuristicType) {
        this.constructionHeuristicType = constructionHeuristicType;
    }

    public List<EntityPlacerConfig> getEntityPlacerConfigList() {
        return this.entityPlacerConfigList;
    }

    public void setEntityPlacerConfigList(List<EntityPlacerConfig> entityPlacerConfigList) {
        this.entityPlacerConfigList = entityPlacerConfigList;
    }

    public ConstructionHeuristicForagerConfig getForagerConfig() {
        return this.foragerConfig;
    }

    public void setForagerConfig(ConstructionHeuristicForagerConfig foragerConfig) {
        this.foragerConfig = foragerConfig;
    }

    @Override
    public ConstructionHeuristicSolverPhase buildSolverPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, Termination solverTermination) {
        EntityPlacerConfig entityPlacerConfig;
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        phaseConfigPolicy.setReinitializeVariableFilterEnabled(true);
        phaseConfigPolicy.setInitializedChainedValueFilterEnabled(true);
        ConstructionHeuristicType constructionHeuristicType_ = this.constructionHeuristicType == null ? ConstructionHeuristicType.FIRST_FIT : this.constructionHeuristicType;
        phaseConfigPolicy.setSortEntitiesByDecreasingDifficultyEnabled(constructionHeuristicType_.isSortEntitiesByDecreasingDifficulty());
        phaseConfigPolicy.setSortValuesByIncreasingStrengthEnabled(constructionHeuristicType_.isSortValuesByIncreasingStrength());
        DefaultConstructionHeuristicSolverPhase phase = new DefaultConstructionHeuristicSolverPhase();
        this.configureSolverPhase(phase, phaseIndex, phaseConfigPolicy, solverTermination);
        phase.setDecider(this.buildDecider(phaseConfigPolicy, phase.getTermination()));
        if (CollectionUtils.isEmpty(this.entityPlacerConfigList)) {
            entityPlacerConfig = new QueuedEntityPlacerConfig();
        } else if (this.entityPlacerConfigList.size() == 1) {
            entityPlacerConfig = this.entityPlacerConfigList.get(0);
        } else {
            throw new IllegalArgumentException("The entityPlacerConfigList (" + this.entityPlacerConfigList + ") must be a singleton or empty. Use multiple " + ConstructionHeuristicSolverPhaseConfig.class + " elements to initialize multiple entity classes.");
        }
        EntityPlacer entityPlacer = ((EntityPlacerConfig)entityPlacerConfig).buildEntityPlacer(phaseConfigPolicy, phase.getTermination());
        phase.setEntityPlacer(entityPlacer);
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            phase.setAssertExpectedStepScore(true);
        }
        return phase;
    }

    private ConstructionHeuristicDecider buildDecider(HeuristicConfigPolicy configPolicy, Termination termination) {
        ConstructionHeuristicForagerConfig foragerConfig_ = this.foragerConfig == null ? new ConstructionHeuristicForagerConfig() : this.foragerConfig;
        ConstructionHeuristicForager forager = foragerConfig_.buildForager(configPolicy);
        ConstructionHeuristicDecider decider = new ConstructionHeuristicDecider(termination, forager);
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    public void inherit(ConstructionHeuristicSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.constructionHeuristicType = ConfigUtils.inheritOverwritableProperty(this.constructionHeuristicType, inheritedConfig.getConstructionHeuristicType());
        this.entityPlacerConfigList = ConfigUtils.inheritMergeableListProperty(this.entityPlacerConfigList, inheritedConfig.getEntityPlacerConfigList());
        if (this.foragerConfig == null) {
            this.foragerConfig = inheritedConfig.getForagerConfig();
        } else if (inheritedConfig.getForagerConfig() != null) {
            this.foragerConfig.inherit(inheritedConfig.getForagerConfig());
        }
    }

    public static enum ConstructionHeuristicType {
        FIRST_FIT,
        FIRST_FIT_DECREASING,
        BEST_FIT,
        BEST_FIT_DECREASING;


        public boolean isSortEntitiesByDecreasingDifficulty() {
            switch (this) {
                case FIRST_FIT: 
                case BEST_FIT: {
                    return false;
                }
                case FIRST_FIT_DECREASING: 
                case BEST_FIT_DECREASING: {
                    return true;
                }
            }
            throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this) + ") is not implemented.");
        }

        public boolean isSortValuesByIncreasingStrength() {
            switch (this) {
                case FIRST_FIT: 
                case FIRST_FIT_DECREASING: {
                    return false;
                }
                case BEST_FIT: 
                case BEST_FIT_DECREASING: {
                    return true;
                }
            }
            throw new IllegalStateException("The constructionHeuristicType (" + (Object)((Object)this) + ") is not implemented.");
        }
    }
}

