/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang.ArrayUtils;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.PlanningEntityDescriptor;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.variable.descriptor.PlanningVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.ChainedMappedByVariableListener;
import org.optaplanner.core.impl.domain.variable.listener.PlanningVariableListener;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;

public class ShadowVariableDescriptor {
    private final PlanningEntityDescriptor entityDescriptor;
    private final PropertyAccessor variablePropertyAccessor;
    private String mappedBy;
    private PlanningVariableDescriptor mappedByVariableDescriptor;

    public ShadowVariableDescriptor(PlanningEntityDescriptor entityDescriptor, PropertyDescriptor propertyDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.variablePropertyAccessor = new ReflectionPropertyAccessor(propertyDescriptor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningVariable planningVariableAnnotation = this.variablePropertyAccessor.getReadMethod().getAnnotation(PlanningVariable.class);
        this.processMappedBy(descriptorPolicy, planningVariableAnnotation);
        this.processNullable(descriptorPolicy, planningVariableAnnotation);
        this.processChained(descriptorPolicy, planningVariableAnnotation);
        this.processValueRangeRefs(descriptorPolicy, planningVariableAnnotation);
        this.processStrength(descriptorPolicy, planningVariableAnnotation);
        this.processVariableListeners(descriptorPolicy, planningVariableAnnotation);
    }

    private void processMappedBy(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        this.mappedBy = planningVariableAnnotation.mappedBy();
        if (this.mappedBy.equals("")) {
            throw new IllegalStateException("Impossible state: the " + PlanningEntityDescriptor.class + " would never try to build a " + ShadowVariableDescriptor.class + " for a non-shadow variable with mappedBy (" + this.mappedBy + ").");
        }
    }

    private void processNullable(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        boolean nullable = planningVariableAnnotation.nullable();
        if (nullable) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which also has nullable (" + nullable + ").");
        }
        Class<? extends SelectionFilter> reinitializeVariableEntityFilterClass = planningVariableAnnotation.reinitializeVariableEntityFilter();
        if (reinitializeVariableEntityFilterClass != PlanningVariable.NullReinitializeVariableEntityFilter.class) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which also has reinitializeVariableEntityFilterClass (" + reinitializeVariableEntityFilterClass + ").");
        }
    }

    private void processChained(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        boolean chained = planningVariableAnnotation.chained();
        if (chained) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which also has chained (" + chained + ").");
        }
    }

    private void processValueRangeRefs(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Object[] valueRangeRefs = planningVariableAnnotation.valueRangeProviderRefs();
        if (!ArrayUtils.isEmpty((Object[])valueRangeRefs)) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which has a non-empty valueRangeProviderRefs (" + Arrays.toString(valueRangeRefs) + ").");
        }
    }

    private void processStrength(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Class<? extends Comparator> strengthComparatorClass = planningVariableAnnotation.strengthComparatorClass();
        if (strengthComparatorClass != PlanningVariable.NullStrengthComparator.class) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which also has strengthComparatorClass (" + strengthComparatorClass + ").");
        }
        Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass = planningVariableAnnotation.strengthWeightFactoryClass();
        if (strengthWeightFactoryClass != PlanningVariable.NullStrengthWeightFactory.class) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which also has strengthWeightFactoryClass (" + strengthWeightFactoryClass + ").");
        }
    }

    private void processVariableListeners(DescriptorPolicy descriptorPolicy, PlanningVariable planningVariableAnnotation) {
        Object[] variableListenerClasses = planningVariableAnnotation.variableListenerClasses();
        if (variableListenerClasses.length != 0) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + planningVariableAnnotation.mappedBy() + ") which also has variableListenerClasses (" + Arrays.toString(variableListenerClasses) + ").");
        }
    }

    public void afterAnnotationsProcessed(DescriptorPolicy descriptorPolicy) {
        Class<?> masterClass = this.getVariablePropertyType();
        PlanningEntityDescriptor mappedByEntityDescriptor = this.getEntityDescriptor().getSolutionDescriptor().getEntityDescriptor(masterClass);
        if (mappedByEntityDescriptor == null) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with a masterClass (" + masterClass + ") which is not a valid planning entity.");
        }
        this.mappedByVariableDescriptor = mappedByEntityDescriptor.getVariableDescriptor(this.mappedBy);
        if (this.mappedByVariableDescriptor == null) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + this.mappedBy + ") which is not a valid planning variable on (" + mappedByEntityDescriptor.getPlanningEntityClass() + ").");
        }
        if (!this.mappedByVariableDescriptor.isChained()) {
            throw new IllegalArgumentException("The planningEntityClass (" + this.entityDescriptor.getPlanningEntityClass() + ") has shadow PlanningVariable annotated property (" + this.variablePropertyAccessor.getName() + ") with mappedBy (" + this.mappedBy + ") which is not a valid planning variable on (" + mappedByEntityDescriptor.getPlanningEntityClass() + ").");
        }
        this.mappedByVariableDescriptor.registerShadowVariableDescriptor(this);
    }

    public PlanningVariableDescriptor getMappedByVariableDescriptor() {
        return this.mappedByVariableDescriptor;
    }

    public PlanningEntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variablePropertyAccessor.getName();
    }

    public Class<?> getVariablePropertyType() {
        return this.variablePropertyAccessor.getPropertyType();
    }

    public PlanningVariableListener buildPlanningVariableListener() {
        return new ChainedMappedByVariableListener(this);
    }

    public Object getValue(Object entity) {
        return this.variablePropertyAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variablePropertyAccessor.executeSetter(entity, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variablePropertyAccessor.getName() + " of " + this.entityDescriptor.getPlanningEntityClass().getName() + ")";
    }
}

