/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.PlanningVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.move.generic.chained.ChainedMoveUtils;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainReversingChangeMove
implements Move {
    private final SubChain subChain;
    private final PlanningVariableDescriptor variableDescriptor;
    private final Object toPlanningValue;

    public SubChainReversingChangeMove(SubChain subChain, PlanningVariableDescriptor variableDescriptor, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstPlanningValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !ObjectUtils.equals((Object)oldFirstPlanningValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldFirstPlanningValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return new SubChainReversingChangeMove(this.subChain.reverse(), this.variableDescriptor, oldFirstPlanningValue);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        ChainedMoveUtils.doReverseSubChainChange(scoreDirector, this.subChain, this.variableDescriptor, this.toPlanningValue);
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainReversingChangeMove) {
            SubChainReversingChangeMove other = (SubChainReversingChangeMove)o;
            return new EqualsBuilder().append((Object)this.subChain, (Object)other.subChain).append((Object)this.variableDescriptor.getVariableName(), (Object)other.variableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.subChain).append((Object)this.variableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        return this.subChain + " reversed => " + this.toPlanningValue;
    }
}

