/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.director;

import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactory;
import org.optaplanner.core.impl.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScoreDirectorFactory
implements ScoreDirectorFactory {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolutionDescriptor solutionDescriptor;
    protected ScoreDefinition scoreDefinition;
    protected ScoreDirectorFactory assertionScoreDirectorFactory = null;

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public void setSolutionDescriptor(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return this.scoreDefinition;
    }

    public void setScoreDefinition(ScoreDefinition scoreDefinition) {
        this.scoreDefinition = scoreDefinition;
    }

    public ScoreDirectorFactory getAssertionScoreDirectorFactory() {
        return this.assertionScoreDirectorFactory;
    }

    public void setAssertionScoreDirectorFactory(ScoreDirectorFactory assertionScoreDirectorFactory) {
        this.assertionScoreDirectorFactory = assertionScoreDirectorFactory;
    }

    @Override
    public void assertScoreFromScratch(Solution solution) {
        Object score = solution.getScore();
        ScoreDirector uncorruptedScoreDirector = this.buildScoreDirector();
        uncorruptedScoreDirector.setWorkingSolution(solution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        uncorruptedScoreDirector.dispose();
        if (!score.equals(uncorruptedScore)) {
            throw new IllegalStateException("Score corruption: the solution's score (" + score + ") is not the uncorruptedScore (" + uncorruptedScore + ").");
        }
    }
}

