/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.exhaustivesearch;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import org.optaplanner.core.config.heuristic.selector.value.ValueSelectorConfig;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.exhaustivesearch.DefaultExhaustiveSearchSolverPhase;
import org.optaplanner.core.impl.exhaustivesearch.ExhaustiveSearchSolverPhase;
import org.optaplanner.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.node.bounder.TrendBasedScoreBounder;
import org.optaplanner.core.impl.exhaustivesearch.node.comparator.BreadthFirstNodeComparator;
import org.optaplanner.core.impl.exhaustivesearch.node.comparator.DepthFirstNodeComparator;
import org.optaplanner.core.impl.exhaustivesearch.node.comparator.OptimisticBoundFirstNodeComparator;
import org.optaplanner.core.impl.exhaustivesearch.node.comparator.OriginalOrderNodeComparator;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="exhaustiveSearch")
public class ExhaustiveSearchSolverPhaseConfig
extends SolverPhaseConfig {
    protected ExhaustiveSearchType exhaustiveSearchType = null;
    protected NodeExplorationType nodeExplorationType = null;
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    @XStreamAlias(value="moveSelector")
    protected MoveSelectorConfig moveSelectorConfig = null;

    public ExhaustiveSearchType getExhaustiveSearchType() {
        return this.exhaustiveSearchType;
    }

    public void setExhaustiveSearchType(ExhaustiveSearchType exhaustiveSearchType) {
        this.exhaustiveSearchType = exhaustiveSearchType;
    }

    public NodeExplorationType getNodeExplorationType() {
        return this.nodeExplorationType;
    }

    public void setNodeExplorationType(NodeExplorationType nodeExplorationType) {
        this.nodeExplorationType = nodeExplorationType;
    }

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public MoveSelectorConfig getMoveSelectorConfig() {
        return this.moveSelectorConfig;
    }

    public void setMoveSelectorConfig(MoveSelectorConfig moveSelectorConfig) {
        this.moveSelectorConfig = moveSelectorConfig;
    }

    @Override
    public ExhaustiveSearchSolverPhase buildSolverPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        phaseConfigPolicy.setInitializedChainedValueFilterEnabled(true);
        ExhaustiveSearchType exhaustiveSearchType_ = this.exhaustiveSearchType == null ? ExhaustiveSearchType.BRANCH_AND_BOUND : this.exhaustiveSearchType;
        phaseConfigPolicy.setSortEntitiesByDecreasingDifficultyEnabled(exhaustiveSearchType_.isSortEntitiesByDecreasingDifficulty());
        phaseConfigPolicy.setSortValuesByIncreasingStrengthEnabled(exhaustiveSearchType_.isSortValuesByIncreasingStrength());
        DefaultExhaustiveSearchSolverPhase phase = new DefaultExhaustiveSearchSolverPhase();
        this.configureSolverPhase(phase, phaseIndex, phaseConfigPolicy, bestSolutionRecaller, solverTermination);
        boolean scoreBounderEnabled = exhaustiveSearchType_.isScoreBounderEnabled();
        NodeExplorationType nodeExplorationType_ = this.nodeExplorationType != null ? this.nodeExplorationType : (exhaustiveSearchType_ == ExhaustiveSearchType.BRUTE_FORCE ? NodeExplorationType.ORIGINAL_ORDER : NodeExplorationType.DEPTH_FIRST);
        phase.setNodeComparator(nodeExplorationType_.buildNodeComparator(scoreBounderEnabled));
        EntitySelectorConfig entitySelectorConfig_ = this.buildEntitySelectorConfig(phaseConfigPolicy);
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(phaseConfigPolicy, SelectionCacheType.PHASE, SelectionOrder.ORIGINAL);
        phase.setEntitySelector(entitySelector);
        phase.setDecider(this.buildDecider(phaseConfigPolicy, entitySelector, bestSolutionRecaller, phase.getTermination(), scoreBounderEnabled));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            phase.setAssertWorkingSolutionScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            phase.setAssertExpectedWorkingSolutionScore(true);
        }
        return phase;
    }

    private EntitySelectorConfig buildEntitySelectorConfig(HeuristicConfigPolicy configPolicy) {
        EntitySelectorConfig entitySelectorConfig_;
        if (this.entitySelectorConfig == null) {
            entitySelectorConfig_ = new EntitySelectorConfig();
            EntityDescriptor entityDescriptor = this.deduceEntityDescriptor(configPolicy.getSolutionDescriptor());
            entitySelectorConfig_.setEntityClass(entityDescriptor.getEntityClass());
            if (configPolicy.isSortEntitiesByDecreasingDifficultyEnabled()) {
                entitySelectorConfig_.setCacheType(SelectionCacheType.PHASE);
                entitySelectorConfig_.setSelectionOrder(SelectionOrder.SORTED);
                entitySelectorConfig_.setSorterManner(EntitySelectorConfig.EntitySorterManner.DECREASING_DIFFICULTY);
            }
        } else {
            entitySelectorConfig_ = this.entitySelectorConfig;
        }
        if (entitySelectorConfig_.getCacheType() != null && entitySelectorConfig_.getCacheType().compareTo(SelectionCacheType.PHASE) < 0) {
            throw new IllegalArgumentException("The solverPhaseConfig (" + this + ") cannot have an entitySelectorConfig (" + entitySelectorConfig_ + ") with a cacheType (" + (Object)((Object)entitySelectorConfig_.getCacheType()) + ") lower than " + (Object)((Object)SelectionCacheType.PHASE) + ".");
        }
        return entitySelectorConfig_;
    }

    protected EntityDescriptor deduceEntityDescriptor(SolutionDescriptor solutionDescriptor) {
        Collection<EntityDescriptor> entityDescriptors = solutionDescriptor.getGenuineEntityDescriptors();
        if (entityDescriptors.size() != 1) {
            throw new IllegalArgumentException("The solverPhaseConfig (" + this + ") has no entitySelector configured" + " and because there are multiple in the planningEntityClassSet (" + solutionDescriptor.getEntityClassSet() + "), it can not be deducted automatically.");
        }
        return entityDescriptors.iterator().next();
    }

    private ExhaustiveSearchDecider buildDecider(HeuristicConfigPolicy configPolicy, EntitySelector sourceEntitySelector, BestSolutionRecaller bestSolutionRecaller, Termination termination, boolean scoreBounderEnabled) {
        ManualEntityMimicRecorder manualEntityMimicRecorder = new ManualEntityMimicRecorder(sourceEntitySelector);
        String mimicSelectorId = sourceEntitySelector.getEntityDescriptor().getEntityClass().getName();
        configPolicy.addEntityMimicRecorder(mimicSelectorId, manualEntityMimicRecorder);
        MoveSelectorConfig moveSelectorConfig_ = this.buildMoveSelectorConfig(configPolicy, sourceEntitySelector, mimicSelectorId);
        MoveSelector moveSelector = moveSelectorConfig_.buildMoveSelector(configPolicy, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL);
        TrendBasedScoreBounder scoreBounder = scoreBounderEnabled ? new TrendBasedScoreBounder(configPolicy.getScoreDirectorFactory()) : null;
        ExhaustiveSearchDecider decider = new ExhaustiveSearchDecider(bestSolutionRecaller, termination, manualEntityMimicRecorder, moveSelector, scoreBounderEnabled, scoreBounder);
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    private MoveSelectorConfig buildMoveSelectorConfig(HeuristicConfigPolicy configPolicy, EntitySelector entitySelector, String mimicSelectorId) {
        MoveSelectorConfig moveSelectorConfig_;
        if (this.moveSelectorConfig == null) {
            EntityDescriptor entityDescriptor = entitySelector.getEntityDescriptor();
            Collection<GenuineVariableDescriptor> variableDescriptors = entityDescriptor.getVariableDescriptors();
            ArrayList<MoveSelectorConfig> subMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptors.size());
            for (GenuineVariableDescriptor variableDescriptor : variableDescriptors) {
                ChangeMoveSelectorConfig changeMoveSelectorConfig = new ChangeMoveSelectorConfig();
                EntitySelectorConfig changeEntitySelectorConfig = new EntitySelectorConfig();
                changeEntitySelectorConfig.setMimicSelectorRef(mimicSelectorId);
                changeMoveSelectorConfig.setEntitySelectorConfig(changeEntitySelectorConfig);
                ValueSelectorConfig changeValueSelectorConfig = new ValueSelectorConfig();
                changeValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
                if (configPolicy.isSortValuesByIncreasingStrengthEnabled()) {
                    if (variableDescriptor.isValueRangeEntityIndependent()) {
                        changeValueSelectorConfig.setCacheType(SelectionCacheType.PHASE);
                    } else {
                        changeValueSelectorConfig.setCacheType(SelectionCacheType.STEP);
                    }
                    changeValueSelectorConfig.setSelectionOrder(SelectionOrder.SORTED);
                    changeValueSelectorConfig.setSorterManner(ValueSelectorConfig.ValueSorterManner.INCREASING_STRENGTH);
                }
                changeMoveSelectorConfig.setValueSelectorConfig(changeValueSelectorConfig);
                subMoveSelectorConfigList.add(changeMoveSelectorConfig);
            }
            moveSelectorConfig_ = subMoveSelectorConfigList.size() > 1 ? new CartesianProductMoveSelectorConfig(subMoveSelectorConfigList) : (MoveSelectorConfig)subMoveSelectorConfigList.get(0);
        } else {
            moveSelectorConfig_ = this.moveSelectorConfig;
        }
        return moveSelectorConfig_;
    }

    public void inherit(ExhaustiveSearchSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.exhaustiveSearchType = ConfigUtils.inheritOverwritableProperty(this.exhaustiveSearchType, inheritedConfig.getExhaustiveSearchType());
        this.nodeExplorationType = ConfigUtils.inheritOverwritableProperty(this.nodeExplorationType, inheritedConfig.getNodeExplorationType());
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
        if (this.moveSelectorConfig == null) {
            this.moveSelectorConfig = inheritedConfig.getMoveSelectorConfig();
        } else if (inheritedConfig.getMoveSelectorConfig() != null) {
            this.moveSelectorConfig.inherit(inheritedConfig.getMoveSelectorConfig());
        }
    }

    public static enum NodeExplorationType {
        ORIGINAL_ORDER,
        DEPTH_FIRST,
        BREADTH_FIRST,
        OPTIMISTIC_BOUND_FIRST;


        public Comparator<ExhaustiveSearchNode> buildNodeComparator(boolean scoreBounderEnabled) {
            switch (this) {
                case ORIGINAL_ORDER: {
                    return new OriginalOrderNodeComparator();
                }
                case DEPTH_FIRST: {
                    return new DepthFirstNodeComparator(scoreBounderEnabled);
                }
                case BREADTH_FIRST: {
                    return new BreadthFirstNodeComparator(scoreBounderEnabled);
                }
                case OPTIMISTIC_BOUND_FIRST: {
                    return new OptimisticBoundFirstNodeComparator(scoreBounderEnabled);
                }
            }
            throw new IllegalStateException("The nodeExplorationType (" + (Object)((Object)this) + ") is not implemented.");
        }
    }

    public static enum ExhaustiveSearchType {
        BRUTE_FORCE,
        BRANCH_AND_BOUND;


        public boolean isSortEntitiesByDecreasingDifficulty() {
            switch (this) {
                case BRUTE_FORCE: {
                    return false;
                }
                case BRANCH_AND_BOUND: {
                    return true;
                }
            }
            throw new IllegalStateException("The exhaustiveSearchType (" + (Object)((Object)this) + ") is not implemented.");
        }

        public boolean isSortValuesByIncreasingStrength() {
            switch (this) {
                case BRUTE_FORCE: {
                    return false;
                }
                case BRANCH_AND_BOUND: {
                    return true;
                }
            }
            throw new IllegalStateException("The exhaustiveSearchType (" + (Object)((Object)this) + ") is not implemented.");
        }

        public boolean isScoreBounderEnabled() {
            switch (this) {
                case BRUTE_FORCE: {
                    return false;
                }
                case BRANCH_AND_BOUND: {
                    return true;
                }
            }
            throw new IllegalStateException("The exhaustiveSearchType (" + (Object)((Object)this) + ") is not implemented.");
        }
    }
}

