/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.phase.custom;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.phase.SolverPhaseConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhase;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.phase.custom.DefaultCustomSolverPhase;
import org.optaplanner.core.impl.solver.recaller.BestSolutionRecaller;
import org.optaplanner.core.impl.solver.termination.Termination;

@XStreamAlias(value="customSolverPhase")
public class CustomSolverPhaseConfig
extends SolverPhaseConfig {
    @XStreamImplicit(itemFieldName="customSolverPhaseCommandClass")
    protected List<Class<? extends CustomSolverPhaseCommand>> customSolverPhaseCommandClassList = null;
    protected Boolean forceUpdateBestSolution = null;

    public List<Class<? extends CustomSolverPhaseCommand>> getCustomSolverPhaseCommandClassList() {
        return this.customSolverPhaseCommandClassList;
    }

    public void setCustomSolverPhaseCommandClassList(List<Class<? extends CustomSolverPhaseCommand>> customSolverPhaseCommandClassList) {
        this.customSolverPhaseCommandClassList = customSolverPhaseCommandClassList;
    }

    public Boolean getForceUpdateBestSolution() {
        return this.forceUpdateBestSolution;
    }

    public void setForceUpdateBestSolution(Boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public CustomSolverPhase buildSolverPhase(int phaseIndex, HeuristicConfigPolicy solverConfigPolicy, BestSolutionRecaller bestSolutionRecaller, Termination solverTermination) {
        HeuristicConfigPolicy phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        DefaultCustomSolverPhase customSolverPhase = new DefaultCustomSolverPhase();
        this.configureSolverPhase(customSolverPhase, phaseIndex, phaseConfigPolicy, bestSolutionRecaller, solverTermination);
        if (ConfigUtils.isEmptyCollection(this.customSolverPhaseCommandClassList)) {
            throw new IllegalArgumentException("Configure at least 1 <customSolverPhaseCommandClass> in the <customSolverPhase> configuration.");
        }
        ArrayList<CustomSolverPhaseCommand> customSolverPhaseCommandList = new ArrayList<CustomSolverPhaseCommand>(this.customSolverPhaseCommandClassList.size());
        for (Class<? extends CustomSolverPhaseCommand> customSolverPhaseCommandClass : this.customSolverPhaseCommandClassList) {
            CustomSolverPhaseCommand customSolverPhaseCommand = ConfigUtils.newInstance(this, "customSolverPhaseCommandClass", customSolverPhaseCommandClass);
            customSolverPhaseCommandList.add(customSolverPhaseCommand);
        }
        customSolverPhase.setCustomSolverPhaseCommandList(customSolverPhaseCommandList);
        customSolverPhase.setForceUpdateBestSolution(this.forceUpdateBestSolution == null ? false : this.forceUpdateBestSolution);
        return customSolverPhase;
    }

    public void inherit(CustomSolverPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.customSolverPhaseCommandClassList = ConfigUtils.inheritMergeableListProperty(this.customSolverPhaseCommandClassList, inheritedConfig.getCustomSolverPhaseCommandClassList());
        this.forceUpdateBestSolution = ConfigUtils.inheritOverwritableProperty(this.forceUpdateBestSolution, inheritedConfig.getForceUpdateBestSolution());
    }
}

