/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.exhaustivesearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.exhaustivesearch.ExhaustiveSearchSolverPhase;
import org.optaplanner.core.impl.exhaustivesearch.decider.ExhaustiveSearchDecider;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import org.optaplanner.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import org.optaplanner.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchSolverPhaseScope;
import org.optaplanner.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.phase.AbstractSolverPhase;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultExhaustiveSearchSolverPhase
extends AbstractSolverPhase
implements ExhaustiveSearchSolverPhase {
    protected Comparator<ExhaustiveSearchNode> nodeComparator;
    protected EntitySelector entitySelector;
    protected ExhaustiveSearchDecider decider;
    protected boolean assertWorkingSolutionScoreFromScratch = false;
    protected boolean assertExpectedWorkingSolutionScore = false;

    public Comparator<ExhaustiveSearchNode> getNodeComparator() {
        return this.nodeComparator;
    }

    public void setNodeComparator(Comparator<ExhaustiveSearchNode> nodeComparator) {
        this.nodeComparator = nodeComparator;
    }

    public EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public void setEntitySelector(EntitySelector entitySelector) {
        this.entitySelector = entitySelector;
    }

    public ExhaustiveSearchDecider getDecider() {
        return this.decider;
    }

    public void setDecider(ExhaustiveSearchDecider decider) {
        this.decider = decider;
    }

    public void setAssertWorkingSolutionScoreFromScratch(boolean assertWorkingSolutionScoreFromScratch) {
        this.assertWorkingSolutionScoreFromScratch = assertWorkingSolutionScoreFromScratch;
    }

    public void setAssertExpectedWorkingSolutionScore(boolean assertExpectedWorkingSolutionScore) {
        this.assertExpectedWorkingSolutionScore = assertExpectedWorkingSolutionScore;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        TreeSet<ExhaustiveSearchNode> expandableNodeQueue = new TreeSet<ExhaustiveSearchNode>(this.nodeComparator);
        ExhaustiveSearchSolverPhaseScope phaseScope = new ExhaustiveSearchSolverPhaseScope(solverScope);
        phaseScope.setExpandableNodeQueue(expandableNodeQueue);
        this.phaseStarted(phaseScope);
        while (!expandableNodeQueue.isEmpty() && !this.termination.isPhaseTerminated(phaseScope)) {
            ExhaustiveSearchStepScope stepScope = new ExhaustiveSearchStepScope(phaseScope);
            ExhaustiveSearchNode node = (ExhaustiveSearchNode)expandableNodeQueue.last();
            expandableNodeQueue.remove(node);
            stepScope.setExpandingNode(node);
            this.stepStarted(stepScope);
            this.restoreWorkingSolution(stepScope);
            this.decider.expandNode(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.entitySelector.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    public void phaseStarted(ExhaustiveSearchSolverPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.entitySelector.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        this.fillLayerList(phaseScope);
        this.initStartNode(phaseScope);
    }

    private void fillLayerList(ExhaustiveSearchSolverPhaseScope phaseScope) {
        ExhaustiveSearchStepScope stepScope = new ExhaustiveSearchStepScope(phaseScope);
        this.entitySelector.stepStarted(stepScope);
        long entitySize = this.entitySelector.getSize();
        if (entitySize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The entitySelector (" + this.entitySelector + ") has an entitySize (" + entitySize + ") which is higher than Integer.MAX_VALUE.");
        }
        int entitySizeInt = (int)entitySize;
        ArrayList<ExhaustiveSearchLayer> layerList = new ArrayList<ExhaustiveSearchLayer>(entitySizeInt);
        int depth = 0;
        for (Object entity : this.entitySelector) {
            ExhaustiveSearchLayer layer = new ExhaustiveSearchLayer(depth, entity, entitySizeInt - depth);
            layerList.add(layer);
            ++depth;
        }
        if (entitySizeInt - depth != 0) {
            throw new IllegalStateException("The entitySelector (" + this.entitySelector + ")'s size (" + entitySizeInt + ") is not accurate enough for exhaustive search.");
        }
        ExhaustiveSearchLayer layer = new ExhaustiveSearchLayer(depth, null, entitySizeInt - depth);
        layerList.add(layer);
        this.entitySelector.stepEnded(stepScope);
        phaseScope.setLayerList(layerList);
    }

    private void initStartNode(ExhaustiveSearchSolverPhaseScope phaseScope) {
        ExhaustiveSearchLayer layer = phaseScope.getLayerList().get(0);
        ExhaustiveSearchNode startNode = new ExhaustiveSearchNode(layer, null);
        if (this.decider.isScoreBounderEnabled()) {
            InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
            Score score = scoreDirector.calculateScore();
            startNode.setScore(score);
            ScoreBounder scoreBounder = this.decider.getScoreBounder();
            phaseScope.setBestPessimisticBound(scoreBounder.calculatePessimisticBound(scoreDirector, score, startNode.getUninitializedVariableCount()));
            startNode.setOptimisticBound(scoreBounder.calculateOptimisticBound(scoreDirector, score, startNode.getUninitializedVariableCount()));
        }
        phaseScope.getExpandableNodeQueue().add(startNode);
        phaseScope.getLastCompletedStepScope().setExpandingNode(startNode);
    }

    public void stepStarted(ExhaustiveSearchStepScope stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    protected void restoreWorkingSolution(ExhaustiveSearchStepScope stepScope) {
        ExhaustiveSearchSolverPhaseScope phaseScope = stepScope.getPhaseScope();
        ExhaustiveSearchNode oldNode = phaseScope.getLastCompletedStepScope().getExpandingNode();
        ExhaustiveSearchNode newNode = stepScope.getExpandingNode();
        ArrayList<Move> oldMoveList = new ArrayList<Move>(oldNode.getDepth());
        ArrayList<Move> newMoveList = new ArrayList<Move>(newNode.getDepth());
        while (oldNode != newNode) {
            int newDepth;
            int oldDepth = oldNode.getDepth();
            if (oldDepth < (newDepth = newNode.getDepth())) {
                newMoveList.add(newNode.getMove());
                newNode = newNode.getParent();
                continue;
            }
            oldMoveList.add(oldNode.getUndoMove());
            oldNode = oldNode.getParent();
        }
        ArrayList<Move> restoreMoveList = new ArrayList<Move>(oldMoveList.size() + newMoveList.size());
        restoreMoveList.addAll(oldMoveList);
        Collections.reverse(newMoveList);
        restoreMoveList.addAll(newMoveList);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        for (Move restoreMove : restoreMoveList) {
            restoreMove.doMove(scoreDirector);
        }
        phaseScope.getWorkingSolution().setScore(stepScope.getScore());
        if (this.assertWorkingSolutionScoreFromScratch) {
            phaseScope.assertWorkingScoreFromScratch(stepScope.getScore(), restoreMoveList);
        }
        if (this.assertExpectedWorkingSolutionScore) {
            phaseScope.assertExpectedWorkingScore(stepScope.getScore(), restoreMoveList);
        }
    }

    public void stepEnded(ExhaustiveSearchStepScope stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.logger.isDebugEnabled()) {
            ExhaustiveSearchSolverPhaseScope phaseScope = stepScope.getPhaseScope();
            long timeMillisSpent = phaseScope.calculateSolverTimeMillisSpent();
            this.logger.debug("    ES step ({}), time spent ({}), depth ({}), breadth ({}), {} best score ({}), selected move count ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpent, stepScope.getDepth(), stepScope.getBreadth(), stepScope.getBestScoreImproved() != false ? "new" : "   ", phaseScope.getBestScoreWithUninitializedPrefix(), stepScope.getSelectedMoveCount()});
        }
    }

    public void phaseEnded(ExhaustiveSearchSolverPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.entitySelector.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        this.logger.info("Exhaustive Search phase ({}) ended: step total ({}), time spent ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getNextStepIndex(), phaseScope.calculateSolverTimeMillisSpent(), phaseScope.getBestScore()});
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.entitySelector.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

