/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class PillarSwapMove
implements Move {
    private final Collection<GenuineVariableDescriptor> variableDescriptors;
    private final List<Object> leftEntityList;
    private final List<Object> rightEntityList;

    public PillarSwapMove(Collection<GenuineVariableDescriptor> variableDescriptors, List<Object> leftEntityList, List<Object> rightEntityList) {
        this.variableDescriptors = variableDescriptors;
        this.leftEntityList = leftEntityList;
        this.rightEntityList = rightEntityList;
    }

    public List<Object> getLeftEntityList() {
        return this.leftEntityList;
    }

    public List<Object> getRightEntityList() {
        return this.rightEntityList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object rightValue;
            Object leftValue = variableDescriptor.getValue(this.leftEntityList.get(0));
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = variableDescriptor.getValue(this.rightEntityList.get(0))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new PillarSwapMove(this.variableDescriptors, this.rightEntityList, this.leftEntityList);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftEntityList.get(0));
            if (ObjectUtils.equals((Object)oldLeftValue, (Object)(oldRightValue = variableDescriptor.getValue(this.rightEntityList.get(0))))) continue;
            for (Object leftEntity : this.leftEntityList) {
                scoreDirector.beforeVariableChanged(leftEntity, variableDescriptor.getVariableName());
                variableDescriptor.setValue(leftEntity, oldRightValue);
                scoreDirector.afterVariableChanged(leftEntity, variableDescriptor.getVariableName());
            }
            for (Object rightEntity : this.rightEntityList) {
                scoreDirector.beforeVariableChanged(rightEntity, variableDescriptor.getVariableName());
                variableDescriptor.setValue(rightEntity, oldLeftValue);
                scoreDirector.afterVariableChanged(rightEntity, variableDescriptor.getVariableName());
            }
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftEntityList.size() + this.rightEntityList.size());
        entities.addAll(this.leftEntityList);
        entities.addAll(this.rightEntityList);
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.variableDescriptors.size() * 2);
        for (GenuineVariableDescriptor variableDescriptor : this.variableDescriptors) {
            values.add(variableDescriptor.getValue(this.leftEntityList.get(0)));
            values.add(variableDescriptor.getValue(this.rightEntityList.get(0)));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PillarSwapMove) {
            PillarSwapMove other = (PillarSwapMove)o;
            return new EqualsBuilder().append(this.variableDescriptors, other.variableDescriptors).append(this.leftEntityList, other.leftEntityList).append(this.rightEntityList, other.rightEntityList).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.variableDescriptors).append(this.leftEntityList).append(this.rightEntityList).toHashCode();
    }

    public String toString() {
        return this.leftEntityList + " <=> " + this.rightEntityList;
    }
}

