/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.aggregator.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.drools.core.util.StringUtils;
import org.optaplanner.benchmark.api.PlannerBenchmarkFactory;
import org.optaplanner.benchmark.config.PlannerBenchmarkConfig;
import org.optaplanner.benchmark.config.report.BenchmarkReportConfig;
import org.optaplanner.benchmark.impl.aggregator.BenchmarkAggregator;
import org.optaplanner.benchmark.impl.aggregator.swingui.CheckBoxTree;
import org.optaplanner.benchmark.impl.aggregator.swingui.MixedCheckBox;
import org.optaplanner.benchmark.impl.aggregator.swingui.SwingUncaughtExceptionHandler;
import org.optaplanner.benchmark.impl.aggregator.swingui.SwingUtils;
import org.optaplanner.benchmark.impl.result.BenchmarkResultIO;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BenchmarkAggregatorFrame
extends JFrame {
    private static final String DETAIL_TEMPLATE_PLANNER_BENCHMARK = "Average score: %s%nAverage problem scale: %d";
    private static final String DETAIL_TEMPLATE_PROBLEM_BENCHMARK = "Problem scale: %d%nUsed memory: %s";
    private static final String DETAIL_TEMPLATE_SINGLE_BENCHMARK = "Score: %s%nPlanning entity count: %d%nUsed memory: %s%nTime spent: %d ms";
    private static final String DETAIL_TEMPLATE_SOLVER_BENCHMARK = "Average score: %s%nTotal score: %s%nAverage time spent: %d ms%nTotal winning score difference: %s";
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BenchmarkAggregator benchmarkAggregator;
    private final BenchmarkResultIO benchmarkResultIO;
    private List<PlannerBenchmarkResult> plannerBenchmarkResultList;
    private Map<SingleBenchmarkResult, DefaultMutableTreeNode> resultCheckBoxMapping = new LinkedHashMap<SingleBenchmarkResult, DefaultMutableTreeNode>();
    private Map<SolverBenchmarkResult, String> solverBenchmarkResultNameMapping = new HashMap<SolverBenchmarkResult, String>();
    private CheckBoxTree checkBoxTree;
    private JTextArea detailTextArea;
    private JProgressBar generateProgressBar;
    private JButton generateReportButton;
    private JButton renameNodeButton;
    private boolean exitApplicationWhenReportFinished = true;

    public static void createAndDisplay(PlannerBenchmarkFactory plannerBenchmarkFactory) {
        SwingUncaughtExceptionHandler.register();
        SwingUtils.fixateLookAndFeel();
        PlannerBenchmarkConfig plannerBenchmarkConfig = plannerBenchmarkFactory.getPlannerBenchmarkConfig();
        BenchmarkAggregator benchmarkAggregator = new BenchmarkAggregator();
        benchmarkAggregator.setBenchmarkDirectory(plannerBenchmarkConfig.getBenchmarkDirectory());
        BenchmarkReportConfig benchmarkReportConfig = plannerBenchmarkConfig.getBenchmarkReportConfig();
        if (benchmarkReportConfig == null) {
            benchmarkReportConfig = new BenchmarkReportConfig();
        }
        benchmarkAggregator.setBenchmarkReportConfig(benchmarkReportConfig);
        BenchmarkAggregatorFrame benchmarkAggregatorFrame = new BenchmarkAggregatorFrame(benchmarkAggregator);
        benchmarkAggregatorFrame.init();
        benchmarkAggregatorFrame.setVisible(true);
    }

    public BenchmarkAggregatorFrame(BenchmarkAggregator benchmarkAggregator) {
        super("Benchmark aggregator");
        this.benchmarkAggregator = benchmarkAggregator;
        this.benchmarkResultIO = new BenchmarkResultIO();
        this.plannerBenchmarkResultList = Collections.emptyList();
    }

    public void init() {
        this.setDefaultCloseOperation(3);
        this.initPlannerBenchmarkResultList();
        this.setContentPane(this.createContentPane());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JComponent createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.createTopButtonPanel(), "North");
        contentPane.add((Component)this.createBenchmarkTreePanel(), "Center");
        contentPane.add((Component)this.createDetailTextArea(), "South");
        return contentPane;
    }

    private JComponent createNoPlannerFoundTextField() {
        String infoMessage = "No planner benchmarks have been found in the benchmarkDirectory (" + this.benchmarkAggregator.getBenchmarkDirectory() + ").";
        JTextPane textPane = new JTextPane();
        textPane.setEditable(false);
        textPane.setText(infoMessage);
        StyledDocument styledDocument = textPane.getStyledDocument();
        SimpleAttributeSet center = new SimpleAttributeSet();
        StyleConstants.setAlignment(center, 1);
        StyleConstants.setBold(center, true);
        styledDocument.setParagraphAttributes(0, styledDocument.getLength(), center, false);
        return textPane;
    }

    private JComponent createDetailTextArea() {
        JPanel detailPanel = new JPanel(new BorderLayout());
        JLabel detailLabel = new JLabel("Details");
        detailPanel.add((Component)detailLabel, "North");
        this.detailTextArea = new JTextArea(5, 80);
        this.detailTextArea.setEditable(false);
        JScrollPane detailScrollPane = new JScrollPane(this.detailTextArea, 22, 30);
        detailPanel.add((Component)detailScrollPane, "South");
        return detailPanel;
    }

    private JComponent createTopButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 6));
        buttonPanel.add(new JButton(new ExpandAllNodesAction()));
        buttonPanel.add(new JButton(new CollapseAllNodesAction()));
        buttonPanel.add(new JButton(new MoveNodeAction(true)));
        buttonPanel.add(new JButton(new MoveNodeAction(false)));
        this.renameNodeButton = new JButton(new RenameNodeAction());
        this.renameNodeButton.setEnabled(false);
        buttonPanel.add(this.renameNodeButton);
        buttonPanel.add(new JButton(new SwitchLevelsAction(false)));
        return buttonPanel;
    }

    private JComponent createBenchmarkTreePanel() {
        JPanel benchmarkTreePanel = new JPanel(new BorderLayout());
        benchmarkTreePanel.add((Component)new JScrollPane(this.plannerBenchmarkResultList.isEmpty() ? this.createNoPlannerFoundTextField() : this.createCheckBoxTree(), 22, 30), "Center");
        JPanel buttonPanelWrapper = new JPanel(new FlowLayout(2));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        this.generateReportButton = new JButton(new GenerateReportAction(this));
        this.generateReportButton.setEnabled(false);
        buttonPanel.add(this.generateReportButton);
        this.generateProgressBar = new JProgressBar();
        buttonPanel.add(this.generateProgressBar);
        buttonPanelWrapper.add(buttonPanel);
        benchmarkTreePanel.add((Component)buttonPanelWrapper, "South");
        benchmarkTreePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        return benchmarkTreePanel;
    }

    private CheckBoxTree createCheckBoxTree() {
        final CheckBoxTree resultCheckBoxTree = new CheckBoxTree(this.initBenchmarkHierarchy(true));
        resultCheckBoxTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treeSelectionPath = e.getNewLeadSelectionPath();
                if (treeSelectionPath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treeSelectionPath.getLastPathComponent();
                    MixedCheckBox checkBox = (MixedCheckBox)treeNode.getUserObject();
                    BenchmarkAggregatorFrame.this.detailTextArea.setText(checkBox.getDetail());
                    BenchmarkAggregatorFrame.this.detailTextArea.setCaretPosition(0);
                    BenchmarkAggregatorFrame.this.renameNodeButton.setEnabled(checkBox.getBenchmarkResult() instanceof PlannerBenchmarkResult || checkBox.getBenchmarkResult() instanceof SolverBenchmarkResult);
                }
            }
        });
        resultCheckBoxTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BenchmarkAggregatorFrame.this.generateReportButton.setEnabled(!resultCheckBoxTree.getSelectedSingleBenchmarkNodes().isEmpty());
            }
        });
        this.checkBoxTree = resultCheckBoxTree;
        return resultCheckBoxTree;
    }

    private void initPlannerBenchmarkResultList() {
        this.plannerBenchmarkResultList = this.benchmarkResultIO.readPlannerBenchmarkResultList(this.benchmarkAggregator.getBenchmarkDirectory());
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            plannerBenchmarkResult.accumulateResults(this.benchmarkAggregator.getBenchmarkReportConfig().buildBenchmarkReport(plannerBenchmarkResult));
        }
    }

    private DefaultMutableTreeNode initBenchmarkHierarchy(boolean solverFirst) {
        DefaultMutableTreeNode parentNode = new DefaultMutableTreeNode(new MixedCheckBox("Planner benchmarks"));
        for (PlannerBenchmarkResult plannerBenchmarkResult : this.plannerBenchmarkResultList) {
            DefaultMutableTreeNode plannerNode = new DefaultMutableTreeNode(this.createPlannerBenchmarkCheckBox(plannerBenchmarkResult));
            parentNode.add(plannerNode);
            if (solverFirst) {
                for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                    DefaultMutableTreeNode solverNode = new DefaultMutableTreeNode(this.createSolverBenchmarkCheckBox(solverBenchmarkResult));
                    plannerNode.add(solverNode);
                    for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
                        DefaultMutableTreeNode problemNode = new DefaultMutableTreeNode(this.createProblemBenchmarkCheckBox(problemBenchmarkResult));
                        solverNode.add(problemNode);
                        this.initSingleBenchmarkNodes(solverBenchmarkResult, problemBenchmarkResult, problemNode);
                    }
                }
                continue;
            }
            for (ProblemBenchmarkResult problemBenchmarkResult : plannerBenchmarkResult.getUnifiedProblemBenchmarkResultList()) {
                DefaultMutableTreeNode problemNode = new DefaultMutableTreeNode(this.createProblemBenchmarkCheckBox(problemBenchmarkResult));
                plannerNode.add(problemNode);
                for (SolverBenchmarkResult solverBenchmarkResult : plannerBenchmarkResult.getSolverBenchmarkResultList()) {
                    DefaultMutableTreeNode solverNode = new DefaultMutableTreeNode(this.createSolverBenchmarkCheckBox(solverBenchmarkResult));
                    problemNode.add(solverNode);
                    this.initSingleBenchmarkNodes(solverBenchmarkResult, problemBenchmarkResult, solverNode);
                }
            }
        }
        return parentNode;
    }

    private void initSingleBenchmarkNodes(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult, DefaultMutableTreeNode problemNode) {
        for (SingleBenchmarkResult singleBenchmarkResult : solverBenchmarkResult.getSingleBenchmarkResultList()) {
            if (!singleBenchmarkResult.getProblemBenchmarkResult().equals(problemBenchmarkResult)) continue;
            DefaultMutableTreeNode singleBenchmarkNode = this.resultCheckBoxMapping.get(singleBenchmarkResult);
            if (singleBenchmarkNode != null) {
                problemNode.add(singleBenchmarkNode);
                continue;
            }
            DefaultMutableTreeNode singleNode = new DefaultMutableTreeNode(this.createSingleBenchmarkCheckBox(singleBenchmarkResult));
            problemNode.add(singleNode);
            this.resultCheckBoxMapping.put(singleBenchmarkResult, singleNode);
        }
    }

    private MixedCheckBox createPlannerBenchmarkCheckBox(PlannerBenchmarkResult plannerBenchmarkResult) {
        String plannerBenchmarkDetail = String.format(DETAIL_TEMPLATE_PLANNER_BENCHMARK, plannerBenchmarkResult.getAverageScore(), plannerBenchmarkResult.getAverageProblemScale());
        return new MixedCheckBox(plannerBenchmarkResult.getName(), plannerBenchmarkDetail, plannerBenchmarkResult);
    }

    private MixedCheckBox createSolverBenchmarkCheckBox(SolverBenchmarkResult solverBenchmarkResult) {
        String solverCheckBoxName = solverBenchmarkResult.getName() + " (" + solverBenchmarkResult.getRanking() + ")";
        String solverBenchmarkDetail = String.format(DETAIL_TEMPLATE_SOLVER_BENCHMARK, solverBenchmarkResult.getAverageScore(), solverBenchmarkResult.getTotalScore(), solverBenchmarkResult.getAverageTimeMillisSpent(), solverBenchmarkResult.getTotalWinningScoreDifference());
        this.solverBenchmarkResultNameMapping.put(solverBenchmarkResult, solverBenchmarkResult.getName());
        return new MixedCheckBox(solverCheckBoxName, solverBenchmarkDetail, solverBenchmarkResult);
    }

    private MixedCheckBox createProblemBenchmarkCheckBox(ProblemBenchmarkResult problemBenchmarkResult) {
        String problemBenchmarkDetail = String.format(DETAIL_TEMPLATE_PROBLEM_BENCHMARK, problemBenchmarkResult.getProblemScale(), this.toEmptyStringIfNull(problemBenchmarkResult.getAverageUsedMemoryAfterInputSolution()));
        return new MixedCheckBox(problemBenchmarkResult.getName(), problemBenchmarkDetail);
    }

    private MixedCheckBox createSingleBenchmarkCheckBox(SingleBenchmarkResult singleBenchmarkResult) {
        String singleCheckBoxName = singleBenchmarkResult.getName() + " (" + singleBenchmarkResult.getRanking() + ")";
        String singleBenchmarkDetail = String.format(DETAIL_TEMPLATE_SINGLE_BENCHMARK, singleBenchmarkResult.getScore(), singleBenchmarkResult.getEntityCount(), this.toEmptyStringIfNull(singleBenchmarkResult.getUsedMemoryAfterInputSolution()), singleBenchmarkResult.getTimeMillisSpent());
        MixedCheckBox singleBenchmarkCheckBox = new MixedCheckBox(singleCheckBoxName, singleBenchmarkDetail, singleBenchmarkResult);
        return singleBenchmarkCheckBox;
    }

    private String toEmptyStringIfNull(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private void refresh() {
        this.initPlannerBenchmarkResultList();
        this.solverBenchmarkResultNameMapping = new HashMap<SolverBenchmarkResult, String>();
        this.resultCheckBoxMapping = new LinkedHashMap<SingleBenchmarkResult, DefaultMutableTreeNode>();
        this.checkBoxTree.setSelectedSingleBenchmarkNodes(new HashSet<DefaultMutableTreeNode>());
        DefaultMutableTreeNode newCheckBoxRootNode = this.initBenchmarkHierarchy(true);
        DefaultTreeModel treeModel = new DefaultTreeModel(newCheckBoxRootNode);
        this.checkBoxTree.setModel(treeModel);
        treeModel.nodeStructureChanged(newCheckBoxRootNode);
        this.setEnabled(true);
    }

    private class ReportFinishedDialog
    extends JDialog {
        private final BenchmarkAggregatorFrame parentFrame;
        private final File reportFile;
        private JCheckBox exitCheckBox;

        public ReportFinishedDialog(BenchmarkAggregatorFrame parentFrame, File reportFile) {
            super((Frame)parentFrame, "Report generation finished");
            this.parentFrame = parentFrame;
            this.reportFile = reportFile;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BenchmarkAggregatorFrame.this.refresh();
                }
            });
            JPanel mainPanel = new JPanel(new BorderLayout(0, 10));
            this.exitCheckBox = new JCheckBox("Exit application", BenchmarkAggregatorFrame.this.exitApplicationWhenReportFinished);
            mainPanel.add((Component)this.exitCheckBox, "North");
            mainPanel.add((Component)this.createButtonPanel(), "Center");
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(mainPanel);
        }

        private JPanel createButtonPanel() {
            final Desktop desktop = Desktop.getDesktop();
            JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 10, 10));
            AbstractAction openBrowserAction = new AbstractAction("Show in browser"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        desktop.browse(ReportFinishedDialog.this.reportFile.getAbsoluteFile().toURI());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed showing reportFile (" + ReportFinishedDialog.this.reportFile + ") in browser.", e);
                    }
                    ReportFinishedDialog.this.finishDialog();
                }
            };
            openBrowserAction.setEnabled(desktop.isSupported(Desktop.Action.BROWSE));
            buttonPanel.add(new JButton(openBrowserAction));
            AbstractAction openFileAction = new AbstractAction("Show in files"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        desktop.open(ReportFinishedDialog.this.reportFile.getParentFile());
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed showing reportFile (" + ReportFinishedDialog.this.reportFile + ") in file explorer.", e);
                    }
                    ReportFinishedDialog.this.finishDialog();
                }
            };
            openBrowserAction.setEnabled(desktop.isSupported(Desktop.Action.OPEN));
            buttonPanel.add(new JButton(openFileAction));
            AbstractAction closeAction = new AbstractAction("Ok"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportFinishedDialog.this.finishDialog();
                }
            };
            buttonPanel.add(new JButton(closeAction));
            return buttonPanel;
        }

        private void finishDialog() {
            BenchmarkAggregatorFrame.this.exitApplicationWhenReportFinished = this.exitCheckBox.isSelected();
            if (BenchmarkAggregatorFrame.this.exitApplicationWhenReportFinished) {
                this.parentFrame.dispose();
            } else {
                this.dispose();
                this.parentFrame.refresh();
            }
        }
    }

    private class GenerateReportWorker
    extends SwingWorker<File, Void> {
        private final BenchmarkAggregatorFrame parentFrame;
        private List<SingleBenchmarkResult> singleBenchmarkResultList;

        public GenerateReportWorker(BenchmarkAggregatorFrame parentFrame, List<SingleBenchmarkResult> singleBenchmarkResultList) {
            this.parentFrame = parentFrame;
            this.singleBenchmarkResultList = singleBenchmarkResultList;
        }

        @Override
        protected File doInBackground() {
            return BenchmarkAggregatorFrame.this.benchmarkAggregator.aggregate(this.singleBenchmarkResultList, BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping);
        }

        @Override
        protected void done() {
            try {
                File htmlOverviewFile = (File)this.get();
                ReportFinishedDialog dialog = new ReportFinishedDialog(this.parentFrame, htmlOverviewFile);
                dialog.pack();
                dialog.setLocationRelativeTo(this.parentFrame);
                dialog.setVisible(true);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("The report generation failed.", e);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("The report generation failed.", e.getCause());
            }
            finally {
                BenchmarkAggregatorFrame.this.detailTextArea.setText(null);
                BenchmarkAggregatorFrame.this.generateProgressBar.setIndeterminate(false);
                BenchmarkAggregatorFrame.this.generateProgressBar.setString(null);
                BenchmarkAggregatorFrame.this.generateProgressBar.setStringPainted(false);
            }
        }
    }

    private class RenameNodeDialog
    extends JDialog {
        public RenameNodeDialog(final DefaultMutableTreeNode treeNode) {
            super((Frame)BenchmarkAggregatorFrame.this, "Rename node");
            final MixedCheckBox mixedCheckBox = (MixedCheckBox)treeNode.getUserObject();
            final Object benchmarkResult = mixedCheckBox.getBenchmarkResult();
            JPanel mainPanel = new JPanel(new BorderLayout());
            String benchmarkResultTextFieldText = null;
            if (benchmarkResult instanceof SolverBenchmarkResult) {
                benchmarkResultTextFieldText = (String)BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping.get(benchmarkResult);
            }
            final JTextField benchmarkResultNameTextField = new JTextField(benchmarkResultTextFieldText == null ? benchmarkResult.toString() : benchmarkResultTextFieldText, 30);
            mainPanel.add((Component)benchmarkResultNameTextField, "West");
            AbstractAction renamedAction = new AbstractAction("Rename"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String newBenchmarkResultName = benchmarkResultNameTextField.getText();
                    if (StringUtils.isEmpty((CharSequence)newBenchmarkResultName)) {
                        JOptionPane.showMessageDialog(BenchmarkAggregatorFrame.this, "New benchmark's name cannot be empty.", "Warning", 2);
                    } else {
                        if (benchmarkResult instanceof PlannerBenchmarkResult) {
                            ((PlannerBenchmarkResult)benchmarkResult).setName(newBenchmarkResultName);
                            mixedCheckBox.setText(newBenchmarkResultName);
                            ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeChanged(treeNode);
                        } else if (benchmarkResult instanceof SolverBenchmarkResult) {
                            mixedCheckBox.setText(newBenchmarkResultName + " (" + ((SolverBenchmarkResult)benchmarkResult).getRanking() + ")");
                            ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeChanged(treeNode);
                            BenchmarkAggregatorFrame.this.solverBenchmarkResultNameMapping.put((SolverBenchmarkResult)benchmarkResult, newBenchmarkResultName);
                        }
                        RenameNodeDialog.this.dispose();
                    }
                }
            };
            benchmarkResultNameTextField.addActionListener(renamedAction);
            JButton confirmRenameButton = new JButton(renamedAction);
            mainPanel.add((Component)confirmRenameButton, "East");
            mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setContentPane(mainPanel);
        }
    }

    private class SwitchLevelsAction
    extends AbstractAction {
        private boolean solverLevelFirst;

        public SwitchLevelsAction(boolean solverLevelFirst) {
            super("Switch levels", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("switchTree.png")));
            this.solverLevelFirst = solverLevelFirst;
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode treeRoot = BenchmarkAggregatorFrame.this.initBenchmarkHierarchy(this.solverLevelFirst);
            DefaultTreeModel treeModel = new DefaultTreeModel(treeRoot);
            BenchmarkAggregatorFrame.this.checkBoxTree.setModel(treeModel);
            treeModel.nodeStructureChanged(treeRoot);
            this.solverLevelFirst = !this.solverLevelFirst;
            BenchmarkAggregatorFrame.this.checkBoxTree.setSelectedSingleBenchmarkNodes(new HashSet<DefaultMutableTreeNode>());
            for (Map.Entry entry : BenchmarkAggregatorFrame.this.resultCheckBoxMapping.entrySet()) {
                if (((MixedCheckBox)((DefaultMutableTreeNode)entry.getValue()).getUserObject()).getStatus() != MixedCheckBox.MixedCheckBoxStatus.CHECKED) continue;
                BenchmarkAggregatorFrame.this.checkBoxTree.getSelectedSingleBenchmarkNodes().add((DefaultMutableTreeNode)entry.getValue());
            }
            BenchmarkAggregatorFrame.this.checkBoxTree.updateHierarchyCheckBoxStates();
        }
    }

    private class RenameNodeAction
    extends AbstractAction {
        public RenameNodeAction() {
            super("Rename", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("rename.png")));
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            MixedCheckBox mixedCheckBox;
            if (BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath() != null && ((mixedCheckBox = (MixedCheckBox)(selectedNode = (DefaultMutableTreeNode)BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath().getLastPathComponent()).getUserObject()).getBenchmarkResult() instanceof PlannerBenchmarkResult || mixedCheckBox.getBenchmarkResult() instanceof SolverBenchmarkResult)) {
                RenameNodeDialog renameNodeDialog = new RenameNodeDialog(selectedNode);
                renameNodeDialog.pack();
                renameNodeDialog.setLocationRelativeTo(BenchmarkAggregatorFrame.this);
                renameNodeDialog.setVisible(true);
            }
        }
    }

    private class MoveNodeAction
    extends AbstractAction {
        private boolean directionUp;

        public MoveNodeAction(boolean directionUp) {
            super(directionUp ? "Move up" : "Move down", new ImageIcon(BenchmarkAggregatorFrame.class.getResource(directionUp ? "moveUp.png" : "moveDown.png")));
            this.directionUp = directionUp;
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selectedNode;
            DefaultMutableTreeNode parentNode;
            if (BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath() != null && (parentNode = (DefaultMutableTreeNode)(selectedNode = (DefaultMutableTreeNode)BenchmarkAggregatorFrame.this.checkBoxTree.getSelectionPath().getLastPathComponent()).getParent()) != null) {
                DefaultMutableTreeNode immediateSiblingNode;
                DefaultMutableTreeNode defaultMutableTreeNode = immediateSiblingNode = this.directionUp ? (DefaultMutableTreeNode)parentNode.getChildBefore(selectedNode) : (DefaultMutableTreeNode)parentNode.getChildAfter(selectedNode);
                if (immediateSiblingNode != null) {
                    parentNode.insert(immediateSiblingNode, parentNode.getIndex(selectedNode));
                    ((DefaultTreeModel)BenchmarkAggregatorFrame.this.checkBoxTree.getModel()).nodeStructureChanged(parentNode);
                    BenchmarkAggregatorFrame.this.checkBoxTree.setSelectionPath(new TreePath(selectedNode.getPath()));
                }
            }
        }
    }

    private class CollapseAllNodesAction
    extends AbstractAction {
        public CollapseAllNodesAction() {
            super("Collapse all", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("collapseAll.png")));
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BenchmarkAggregatorFrame.this.checkBoxTree.collapseAllNodes();
        }
    }

    private class ExpandAllNodesAction
    extends AbstractAction {
        public ExpandAllNodesAction() {
            super("Expand all", new ImageIcon(BenchmarkAggregatorFrame.class.getResource("expandAll.png")));
            this.setEnabled(!BenchmarkAggregatorFrame.this.plannerBenchmarkResultList.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BenchmarkAggregatorFrame.this.checkBoxTree.expandAllNodes();
        }
    }

    private class GenerateReportAction
    extends AbstractAction {
        private final BenchmarkAggregatorFrame parentFrame;

        public GenerateReportAction(BenchmarkAggregatorFrame parentFrame) {
            super("Generate report");
            this.parentFrame = parentFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parentFrame.setEnabled(false);
            this.generateReport();
        }

        private void generateReport() {
            ArrayList<SingleBenchmarkResult> singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>();
            for (Map.Entry entry : BenchmarkAggregatorFrame.this.resultCheckBoxMapping.entrySet()) {
                if (((MixedCheckBox)((DefaultMutableTreeNode)entry.getValue()).getUserObject()).getStatus() != MixedCheckBox.MixedCheckBoxStatus.CHECKED) continue;
                singleBenchmarkResultList.add((SingleBenchmarkResult)entry.getKey());
            }
            if (singleBenchmarkResultList.isEmpty()) {
                JOptionPane.showMessageDialog(this.parentFrame, "No single benchmarks have been selected.", "Warning", 2);
                this.parentFrame.setEnabled(true);
            } else {
                BenchmarkAggregatorFrame.this.generateProgressBar.setIndeterminate(true);
                BenchmarkAggregatorFrame.this.generateProgressBar.setStringPainted(true);
                BenchmarkAggregatorFrame.this.generateProgressBar.setString("Generating...");
                GenerateReportWorker worker = new GenerateReportWorker(this.parentFrame, singleBenchmarkResultList);
                worker.execute();
            }
        }
    }
}

