/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

@XStreamAlias(value="singleBenchmarkResult")
public class SingleBenchmarkResult {
    @XStreamOmitField
    private SolverBenchmarkResult solverBenchmarkResult;
    @XStreamOmitField
    private ProblemBenchmarkResult problemBenchmarkResult;
    @XStreamOmitField
    private Map<StatisticType, SingleStatistic> singleStatisticMap;
    private Integer entityCount = null;
    private Long usedMemoryAfterInputSolution = null;
    private Boolean succeeded = null;
    private Score score = null;
    private long timeMillisSpent = -1L;
    private long calculateCount = -1L;
    private Score winningScoreDifference = null;
    private ScoreDifferencePercentage worstScoreDifferencePercentage = null;
    private Integer ranking = null;

    public SingleBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult) {
        this.solverBenchmarkResult = solverBenchmarkResult;
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public void initSingleStatisticMap() {
        this.singleStatisticMap = new HashMap<StatisticType, SingleStatistic>(this.problemBenchmarkResult.getProblemStatisticList().size());
        for (ProblemStatistic problemStatistic : this.problemBenchmarkResult.getProblemStatisticList()) {
            SingleStatistic singleStatistic = problemStatistic.createSingleStatistic(this);
            this.singleStatisticMap.put(problemStatistic.getProblemStatisticType(), singleStatistic);
        }
    }

    public SolverBenchmarkResult getSolverBenchmarkResult() {
        return this.solverBenchmarkResult;
    }

    public void setSolverBenchmarkResult(SolverBenchmarkResult solverBenchmarkResult) {
        this.solverBenchmarkResult = solverBenchmarkResult;
    }

    public ProblemBenchmarkResult getProblemBenchmarkResult() {
        return this.problemBenchmarkResult;
    }

    public void setProblemBenchmarkResult(ProblemBenchmarkResult problemBenchmarkResult) {
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public Map<StatisticType, SingleStatistic> getSingleStatisticMap() {
        return this.singleStatisticMap;
    }

    public Integer getEntityCount() {
        return this.entityCount;
    }

    public void setEntityCount(Integer entityCount) {
        this.entityCount = entityCount;
    }

    public Long getUsedMemoryAfterInputSolution() {
        return this.usedMemoryAfterInputSolution;
    }

    public void setUsedMemoryAfterInputSolution(Long usedMemoryAfterInputSolution) {
        this.usedMemoryAfterInputSolution = usedMemoryAfterInputSolution;
    }

    public Boolean getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Boolean succeeded) {
        this.succeeded = succeeded;
    }

    public Score getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public long getTimeMillisSpent() {
        return this.timeMillisSpent;
    }

    public void setTimeMillisSpent(long timeMillisSpent) {
        this.timeMillisSpent = timeMillisSpent;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public void setCalculateCount(long calculateCount) {
        this.calculateCount = calculateCount;
    }

    public Score getWinningScoreDifference() {
        return this.winningScoreDifference;
    }

    public void setWinningScoreDifference(Score winningScoreDifference) {
        this.winningScoreDifference = winningScoreDifference;
    }

    public ScoreDifferencePercentage getWorstScoreDifferencePercentage() {
        return this.worstScoreDifferencePercentage;
    }

    public void setWorstScoreDifferencePercentage(ScoreDifferencePercentage worstScoreDifferencePercentage) {
        this.worstScoreDifferencePercentage = worstScoreDifferencePercentage;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public String getName() {
        return this.problemBenchmarkResult.getName() + "_" + this.solverBenchmarkResult.getName();
    }

    public File getBenchmarkReportDirectory() {
        return this.problemBenchmarkResult.getBenchmarkReportDirectory();
    }

    public boolean isSuccess() {
        return this.succeeded != null && this.succeeded != false;
    }

    public boolean isFailure() {
        return this.succeeded != null && this.succeeded == false;
    }

    public boolean isScoreFeasible() {
        if (this.score instanceof FeasibilityScore) {
            return ((FeasibilityScore)this.score).isFeasible();
        }
        return true;
    }

    public Long getAverageCalculateCountPerSecond() {
        long timeMillisSpent = this.timeMillisSpent;
        if (timeMillisSpent == 0L) {
            timeMillisSpent = 1L;
        }
        return this.calculateCount * 1000L / timeMillisSpent;
    }

    public boolean isWinner() {
        return this.ranking != null && this.ranking == 0;
    }

    public SingleStatistic getSingleStatistic(StatisticType statisticType) {
        return this.singleStatisticMap.get(statisticType);
    }

    public String getSingleReportDirectoryPath() {
        return this.problemBenchmarkResult.getProblemReportDirectoryPath() + "/" + this.solverBenchmarkResult.getName();
    }

    public File getSingleReportDirectory() {
        return new File(this.getBenchmarkReportDirectory(), this.getSingleReportDirectoryPath());
    }

    public void makeDirs(File problemReportDirectory) {
        File singleReportDirectory = this.getSingleReportDirectory();
        singleReportDirectory.mkdirs();
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
    }

    protected static SingleBenchmarkResult createMerge(SolverBenchmarkResult solverBenchmarkResult, ProblemBenchmarkResult problemBenchmarkResult, SingleBenchmarkResult oldResult) {
        SingleBenchmarkResult newResult = new SingleBenchmarkResult(solverBenchmarkResult, problemBenchmarkResult);
        newResult.initSingleStatisticMap();
        for (SingleStatistic singleStatistic : newResult.singleStatisticMap.values()) {
            singleStatistic.setPointList(oldResult.getSingleStatistic(singleStatistic.getStatisticType()).getPointList());
        }
        newResult.entityCount = oldResult.entityCount;
        newResult.succeeded = oldResult.succeeded;
        newResult.score = oldResult.score;
        newResult.timeMillisSpent = oldResult.timeMillisSpent;
        newResult.calculateCount = oldResult.calculateCount;
        solverBenchmarkResult.getSingleBenchmarkResultList().add(newResult);
        problemBenchmarkResult.getSingleBenchmarkResultList().add(newResult);
        return newResult;
    }

    public String toString() {
        return this.getName();
    }
}

