/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.field;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.spi.FieldValue;

public class ClassFieldImpl
implements FieldValue,
Externalizable {
    private Class type;
    private String className;

    public ClassFieldImpl(Class value) {
        this.className = value.getName();
        this.type = null;
    }

    public ClassFieldImpl(String value) {
        this.className = value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.type);
        out.writeObject(this.className);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (Class)in.readObject();
        this.className = (String)in.readObject();
    }

    @Override
    public Object getValue() {
        return this.type;
    }

    public Object resolve(InternalWorkingMemory workingMemory) {
        try {
            this.type = workingMemory.getKnowledgeBase().getRootClassLoader().loadClass(this.className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.type;
    }

    @Override
    public char getCharValue() {
        return '\u0000';
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return null;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return null;
    }

    @Override
    public int getIntValue() {
        return 0;
    }

    @Override
    public byte getByteValue() {
        return 0;
    }

    @Override
    public short getShortValue() {
        return 0;
    }

    @Override
    public long getLongValue() {
        return 0L;
    }

    @Override
    public float getFloatValue() {
        return 0.0f;
    }

    @Override
    public double getDoubleValue() {
        return 0.0;
    }

    @Override
    public boolean getBooleanValue() {
        return false;
    }

    @Override
    public boolean isNull() {
        return this.className == null;
    }

    @Override
    public boolean isBooleanField() {
        return false;
    }

    @Override
    public boolean isIntegerNumberField() {
        return false;
    }

    @Override
    public boolean isFloatNumberField() {
        return false;
    }

    @Override
    public boolean isObjectField() {
        return true;
    }

    @Override
    public boolean isCollectionField() {
        return false;
    }

    @Override
    public boolean isStringField() {
        return false;
    }
}

