/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.common.persistence;

import java.io.File;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionDao;
import org.optaplanner.persistence.xstream.XStreamProblemIO;

public abstract class XStreamSolutionDao
extends AbstractSolutionDao {
    protected XStreamProblemIO xStreamProblemIO;

    public XStreamSolutionDao(String dirName, Class ... xStreamAnnotations) {
        super(dirName);
        this.xStreamProblemIO = new XStreamProblemIO(xStreamAnnotations);
    }

    @Override
    public String getFileExtension() {
        return "xml";
    }

    @Override
    public Solution readSolution(File inputSolutionFile) {
        Solution solution = this.xStreamProblemIO.read(inputSolutionFile);
        this.logger.info("Opened: {}", (Object)inputSolutionFile);
        return solution;
    }

    @Override
    public void writeSolution(Solution solution, File outputSolutionFile) {
        this.xStreamProblemIO.write(solution, outputSolutionFile);
        this.logger.info("Saved: {}", (Object)outputSolutionFile);
    }
}

