/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.dinnerparty.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.phase.custom.CustomSolverPhaseCommand;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.common.domain.PersistableIdComparator;
import org.optaplanner.examples.dinnerparty.domain.DinnerParty;
import org.optaplanner.examples.dinnerparty.domain.Guest;
import org.optaplanner.examples.dinnerparty.domain.Seat;
import org.optaplanner.examples.dinnerparty.domain.SeatDesignation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinnerPartySolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void changeWorkingSolution(ScoreDirector scoreDirector) {
        DinnerParty dinnerParty = (DinnerParty)scoreDirector.getWorkingSolution();
        this.initializeSeatDesignationList(scoreDirector, dinnerParty);
    }

    private void initializeSeatDesignationList(ScoreDirector scoreDirector, DinnerParty dinnerParty) {
        List<SeatDesignation> seatDesignationList = this.createSeatDesignationList(dinnerParty);
        ArrayList<Seat> undesignatedSeatList = new ArrayList<Seat>(dinnerParty.getSeatList());
        for (SeatDesignation seatDesignation : seatDesignationList) {
            Score<SimpleScore> bestScore = SimpleScore.valueOf(Integer.MIN_VALUE);
            Seat bestSeat = null;
            boolean added = false;
            for (Seat seat : undesignatedSeatList) {
                Score score;
                if (seatDesignation.getGuest().getGender() != seat.getRequiredGender()) continue;
                if (!added) {
                    scoreDirector.beforeEntityAdded(seatDesignation);
                    seatDesignation.setSeat(seat);
                    scoreDirector.afterEntityAdded(seatDesignation);
                    added = true;
                } else {
                    scoreDirector.beforeVariableChanged(seatDesignation, "seat");
                    seatDesignation.setSeat(seat);
                    scoreDirector.afterVariableChanged(seatDesignation, "seat");
                }
                if ((score = scoreDirector.calculateScore()).compareTo(bestScore) <= 0) continue;
                bestScore = score;
                bestSeat = seat;
            }
            if (bestSeat == null) {
                throw new IllegalStateException("The bestSeat (" + bestSeat + ") cannot be null.");
            }
            scoreDirector.beforeVariableChanged(seatDesignation, "seat");
            seatDesignation.setSeat(bestSeat);
            scoreDirector.afterVariableChanged(seatDesignation, "seat");
            undesignatedSeatList.remove(bestSeat);
        }
        Collections.sort(seatDesignationList, new PersistableIdComparator());
        dinnerParty.setSeatDesignationList(seatDesignationList);
    }

    private List<SeatDesignation> createSeatDesignationList(DinnerParty dinnerParty) {
        ArrayList<SeatDesignation> seatDesignationList = new ArrayList<SeatDesignation>(dinnerParty.getGuestList().size());
        for (Guest guest : dinnerParty.getGuestList()) {
            SeatDesignation seatDesignation = new SeatDesignation();
            seatDesignation.setId(guest.getId());
            seatDesignation.setGuest(guest);
            seatDesignationList.add(seatDesignation);
        }
        return seatDesignationList;
    }
}

