/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.LeadingExam;
import org.optaplanner.examples.examination.domain.PeriodPenalty;

public class ExamDifficultyWeightFactory
implements SelectionSorterWeightFactory<Examination, Exam> {
    @Override
    public Comparable createSorterWeight(Examination examination, Exam exam) {
        int studentSizeTotal = exam.getTopicStudentSize();
        int maximumDuration = exam.getTopicDuration();
        block10: for (PeriodPenalty periodPenalty : examination.getPeriodPenaltyList()) {
            if (periodPenalty.getLeftSideTopic().equals(exam.getTopic())) {
                switch (periodPenalty.getPeriodPenaltyType()) {
                    case EXAM_COINCIDENCE: {
                        studentSizeTotal += periodPenalty.getRightSideTopic().getStudentSize();
                        maximumDuration = Math.max(maximumDuration, periodPenalty.getRightSideTopic().getDuration());
                        continue block10;
                    }
                    case EXCLUSION: {
                        continue block10;
                    }
                    case AFTER: {
                        continue block10;
                    }
                }
                throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenalty.getPeriodPenaltyType()) + ") is not implemented.");
            }
            if (!periodPenalty.getRightSideTopic().equals(exam.getTopic())) continue;
            switch (periodPenalty.getPeriodPenaltyType()) {
                case EXAM_COINCIDENCE: {
                    studentSizeTotal += periodPenalty.getLeftSideTopic().getStudentSize();
                    maximumDuration = Math.max(maximumDuration, periodPenalty.getLeftSideTopic().getDuration());
                    continue block10;
                }
                case EXCLUSION: {
                    continue block10;
                }
                case AFTER: {
                    studentSizeTotal += periodPenalty.getLeftSideTopic().getStudentSize();
                    maximumDuration = Math.max(maximumDuration, periodPenalty.getLeftSideTopic().getDuration());
                    continue block10;
                }
            }
            throw new IllegalStateException("The periodPenaltyType (" + (Object)((Object)periodPenalty.getPeriodPenaltyType()) + ") is not implemented.");
        }
        return new ExamDifficultyWeight(exam, studentSizeTotal, maximumDuration);
    }

    public static class ExamDifficultyWeight
    implements Comparable<ExamDifficultyWeight> {
        private final Exam exam;
        private final int studentSizeTotal;
        private final int maximumDuration;

        public ExamDifficultyWeight(Exam exam, int studentSizeTotal, int maximumDuration) {
            this.exam = exam;
            this.studentSizeTotal = studentSizeTotal;
            this.maximumDuration = maximumDuration;
        }

        @Override
        public int compareTo(ExamDifficultyWeight other) {
            return new CompareToBuilder().append(this.studentSizeTotal, other.studentSizeTotal).append(this.maximumDuration, other.maximumDuration).append(this.exam instanceof LeadingExam, other.exam instanceof LeadingExam).append((Object)this.exam.getId(), (Object)other.exam.getId()).toComparison();
        }
    }
}

