/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;

public class RowChangeMove
implements Move {
    private Queen queen;
    private Row toRow;

    public RowChangeMove(Queen queen, Row toRow) {
        this.queen = queen;
        this.toRow = toRow;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.queen.getRow(), (Object)this.toRow);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new RowChangeMove(this.queen, this.queen.getRow());
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        scoreDirector.beforeVariableChanged(this.queen, "row");
        this.queen.setRow(this.toRow);
        scoreDirector.afterVariableChanged(this.queen, "row");
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.queen);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toRow);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RowChangeMove) {
            RowChangeMove other = (RowChangeMove)o;
            return new EqualsBuilder().append((Object)this.queen, (Object)other.queen).append((Object)this.toRow, (Object)other.toRow).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.queen).append((Object)this.toRow).toHashCode();
    }

    public String toString() {
        return this.queen + " => " + this.toRow;
    }
}

