/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Random;
import javax.swing.JTabbedPane;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Location;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.swingui.VehicleRoutingWorldPanel;

public class VehicleRoutingPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/vehiclerouting/swingui/vehicleRoutingLogo.png";
    private VehicleRoutingWorldPanel vehicleRoutingWorldPanel;
    private Random demandRandom = new Random(37L);
    private Long nextLocationId = null;

    public VehicleRoutingPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.vehicleRoutingWorldPanel = new VehicleRoutingWorldPanel(this);
        this.vehicleRoutingWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.vehicleRoutingWorldPanel);
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public VehicleRoutingSolution getSchedule() {
        return (VehicleRoutingSolution)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        VehicleRoutingSolution schedule = (VehicleRoutingSolution)solution;
        this.vehicleRoutingWorldPanel.resetPanel(schedule);
        this.resetNextLocationId();
    }

    private void resetNextLocationId() {
        long highestLocationId = 0L;
        for (Location location : this.getSchedule().getLocationList()) {
            if (highestLocationId >= location.getId()) continue;
            highestLocationId = location.getId();
        }
        this.nextLocationId = highestLocationId + 1L;
    }

    @Override
    public void updatePanel(Solution solution) {
        VehicleRoutingSolution schedule = (VehicleRoutingSolution)solution;
        this.vehicleRoutingWorldPanel.updatePanel(schedule);
    }

    public void doMove(Move move) {
        this.solutionBusiness.doMove(move);
    }

    public SolverAndPersistenceFrame getWorkflowFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void insertLocationAndCustomer(double longitude, double latitude) {
        final Location newLocation = new Location();
        newLocation.setId(this.nextLocationId);
        Long l = this.nextLocationId;
        Long l2 = this.nextLocationId = Long.valueOf(this.nextLocationId + 1L);
        newLocation.setLongitude(longitude);
        newLocation.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newLocation ({}).", (Object)newLocation);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            @Override
            public void doChange(ScoreDirector scoreDirector) {
                Customer newCustomer;
                VehicleRoutingSolution schedule = (VehicleRoutingSolution)scoreDirector.getWorkingSolution();
                scoreDirector.beforeProblemFactAdded(newLocation);
                schedule.getLocationList().add(newLocation);
                scoreDirector.afterProblemFactAdded(newLocation);
                if (schedule instanceof TimeWindowedVehicleRoutingSolution) {
                    TimeWindowedCustomer newTimeWindowedCustomer = new TimeWindowedCustomer();
                    TimeWindowedDepot timeWindowedDepot = (TimeWindowedDepot)schedule.getDepotList().get(0);
                    int windowTime = (timeWindowedDepot.getDueTime() - timeWindowedDepot.getReadyTime()) / 4;
                    int readyTime = VehicleRoutingPanel.this.demandRandom.nextInt(windowTime * 3);
                    newTimeWindowedCustomer.setReadyTime(readyTime);
                    newTimeWindowedCustomer.setDueTime(readyTime + windowTime);
                    newTimeWindowedCustomer.setServiceDuration(Math.min(10000, windowTime / 2));
                    newCustomer = newTimeWindowedCustomer;
                } else {
                    newCustomer = new Customer();
                }
                newCustomer.setId(newLocation.getId());
                newCustomer.setLocation(newLocation);
                newCustomer.setDemand(VehicleRoutingPanel.this.demandRandom.nextInt(10) + 1);
                scoreDirector.beforeEntityAdded(newCustomer);
                schedule.getCustomerList().add(newCustomer);
                scoreDirector.afterEntityAdded(newCustomer);
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }
}

