/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.movecountperstep;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepMeasurement;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.localsearch.scope.LocalSearchStepScope;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.PhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;

public class MoveCountPerStepSingleStatistic
extends SingleStatistic<MoveCountPerStepStatisticPoint> {
    private MoveCountPerStepSingleStatisticListener listener = new MoveCountPerStepSingleStatisticListener();
    private List<MoveCountPerStepStatisticPoint> pointList = new ArrayList<MoveCountPerStepStatisticPoint>();

    public MoveCountPerStepSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        super(singleBenchmarkResult, ProblemStatisticType.MOVE_COUNT_PER_STEP);
    }

    @Override
    public List<MoveCountPerStepStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void setPointList(List<MoveCountPerStepStatisticPoint> pointList) {
        this.pointList = pointList;
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addPhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removePhaseLifecycleListener((PhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return MoveCountPerStepStatisticPoint.buildCsvLine("timeMillisSpent", "acceptedMoveCount", "selectedMoveCount");
    }

    @Override
    protected MoveCountPerStepStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new MoveCountPerStepStatisticPoint(Long.valueOf(csvLine.get(0)), new MoveCountPerStepMeasurement(Long.valueOf(csvLine.get(1)), Long.valueOf(csvLine.get(2))));
    }

    private class MoveCountPerStepSingleStatisticListener
    extends PhaseLifecycleListenerAdapter {
        private MoveCountPerStepSingleStatisticListener() {
        }

        public void stepEnded(AbstractStepScope stepScope) {
            if (stepScope instanceof LocalSearchStepScope) {
                this.localSearchStepEnded((LocalSearchStepScope)stepScope);
            }
        }

        private void localSearchStepEnded(LocalSearchStepScope stepScope) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpent();
            MoveCountPerStepSingleStatistic.this.pointList.add(new MoveCountPerStepStatisticPoint(timeMillisSpent, new MoveCountPerStepMeasurement(stepScope.getAcceptedMoveCount(), stepScope.getSelectedMoveCount())));
        }
    }
}

