/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.valuerange.descriptor;

import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.valuerange.buildin.composite.NullableCountableValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;

public abstract class AbstractValueRangeDescriptor
implements ValueRangeDescriptor {
    protected final GenuineVariableDescriptor variableDescriptor;
    protected final boolean addNullInValueRange;

    public AbstractValueRangeDescriptor(GenuineVariableDescriptor variableDescriptor, boolean addNullInValueRange) {
        this.variableDescriptor = variableDescriptor;
        this.addNullInValueRange = addNullInValueRange;
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.variableDescriptor;
    }

    @Override
    public boolean mightContainEntity() {
        SolutionDescriptor solutionDescriptor = this.variableDescriptor.getEntityDescriptor().getSolutionDescriptor();
        Class<?> variablePropertyType = this.variableDescriptor.getVariablePropertyType();
        for (Class<?> entityClass : solutionDescriptor.getEntityClassSet()) {
            if (!variablePropertyType.isAssignableFrom(entityClass)) continue;
            return true;
        }
        return false;
    }

    protected <T> ValueRange<T> doNullInValueRangeWrapping(ValueRange<T> valueRange) {
        if (this.addNullInValueRange) {
            valueRange = new NullableCountableValueRange((CountableValueRange)valueRange);
        }
        return valueRange;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getVariableName() + ")";
    }
}

