/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value;

import java.util.Iterator;
import org.optaplanner.core.api.domain.valuerange.CountableValueRange;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;

public class FromSolutionPropertyValueSelector
extends AbstractValueSelector
implements EntityIndependentValueSelector {
    protected final EntityIndependentValueRangeDescriptor valueRangeDescriptor;
    protected final SelectionCacheType minimumCacheType;
    protected final boolean randomSelection;
    protected final boolean valueRangeMightContainEntity;
    protected ValueRange<Object> cachedValueRange = null;
    protected Long cachedEntityListRevision = null;
    protected boolean cachedEntityListIsDirty = false;

    public FromSolutionPropertyValueSelector(EntityIndependentValueRangeDescriptor valueRangeDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        this.valueRangeDescriptor = valueRangeDescriptor;
        this.minimumCacheType = minimumCacheType;
        this.randomSelection = randomSelection;
        this.valueRangeMightContainEntity = valueRangeDescriptor.mightContainEntity();
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.valueRangeDescriptor.getVariableDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        SelectionCacheType intrinsicCacheType = this.valueRangeMightContainEntity ? SelectionCacheType.STEP : SelectionCacheType.PHASE;
        return intrinsicCacheType.compareTo(this.minimumCacheType) > 0 ? intrinsicCacheType : this.minimumCacheType;
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
        this.cachedValueRange = this.valueRangeDescriptor.extractValueRange(scoreDirector.getWorkingSolution());
        if (this.valueRangeMightContainEntity) {
            this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
            this.cachedEntityListIsDirty = false;
        }
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        InnerScoreDirector scoreDirector;
        super.stepStarted(stepScope);
        if (this.valueRangeMightContainEntity && (scoreDirector = stepScope.getScoreDirector()).isWorkingEntityListDirty(this.cachedEntityListRevision)) {
            if (this.minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
                this.cachedEntityListIsDirty = true;
            } else {
                this.cachedValueRange = this.valueRangeDescriptor.extractValueRange(scoreDirector.getWorkingSolution());
                this.cachedEntityListRevision = scoreDirector.getWorkingEntityListRevision();
            }
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.cachedValueRange = null;
        if (this.valueRangeMightContainEntity) {
            this.cachedEntityListRevision = null;
            this.cachedEntityListIsDirty = false;
        }
    }

    @Override
    public boolean isCountable() {
        return this.valueRangeDescriptor.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.getSize();
    }

    @Override
    public long getSize() {
        return ((CountableValueRange)this.cachedValueRange).getSize();
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        this.checkCachedEntityListIsDirty();
        if (!this.randomSelection) {
            return ((CountableValueRange)this.cachedValueRange).createOriginalIterator();
        }
        return this.cachedValueRange.createRandomIterator(this.workingRandom);
    }

    private void checkCachedEntityListIsDirty() {
        if (this.cachedEntityListIsDirty) {
            throw new IllegalStateException("The selector (" + this + ") with minimumCacheType (" + (Object)((Object)this.minimumCacheType) + ")'s workingEntityList became dirty between steps but is still used afterwards.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVariableDescriptor().getVariableName() + ")";
    }
}

