/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule.constraint;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.MVELObjectClassFieldReader;
import org.drools.core.base.mvel.MVELCompilationUnit;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.IndexEvaluator;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.MVELDialectRuntimeData;
import org.drools.core.rule.MutableTypeConstraint;
import org.drools.core.rule.constraint.ASMConditionEvaluatorJitter;
import org.drools.core.rule.constraint.ConditionAnalyzer;
import org.drools.core.rule.constraint.ConditionEvaluator;
import org.drools.core.rule.constraint.MvelConditionEvaluator;
import org.drools.core.spi.AcceptsReadAccessor;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.BitMaskUtil;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.MemoryUtil;
import org.drools.core.util.StringUtils;
import org.drools.core.util.index.IndexUtil;
import org.kie.api.runtime.rule.Variable;
import org.kie.internal.concurrent.ExecutorProviderFactory;
import org.mvel2.ParserConfiguration;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExecutableStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MvelConstraint
extends MutableTypeConstraint
implements IndexableConstraint,
AcceptsReadAccessor {
    protected static final boolean TEST_JITTING = false;
    protected static final int JIT_THRESOLD = 20;
    private static final Logger logger = LoggerFactory.getLogger(MvelConstraint.class);
    protected final transient AtomicInteger invocationCounter = new AtomicInteger(1);
    protected transient boolean jitted = false;
    private String packageName;
    protected String expression;
    private IndexUtil.ConstraintType constraintType = IndexUtil.ConstraintType.UNKNOWN;
    private Declaration[] declarations;
    private Declaration indexingDeclaration;
    private InternalReadAccessor extractor;
    private boolean isUnification;
    protected boolean isDynamic;
    private FieldValue fieldValue;
    protected MVELCompilationUnit compilationUnit;
    protected volatile transient ConditionEvaluator conditionEvaluator;
    private volatile transient ConditionAnalyzer.Condition analyzedCondition;
    public static final IndexEvaluator INDEX_EVALUATOR = new PlainIndexEvaluator();

    public MvelConstraint() {
    }

    public MvelConstraint(String packageName, String expression, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, FieldValue fieldValue, InternalReadAccessor extractor) {
        this.packageName = packageName;
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = constraintType;
        this.declarations = new Declaration[0];
        this.fieldValue = fieldValue;
        this.extractor = extractor;
    }

    public MvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, boolean isDynamic) {
        this.packageName = packageName;
        this.expression = expression;
        this.declarations = declarations;
        this.compilationUnit = compilationUnit;
        this.isDynamic = isDynamic;
    }

    public MvelConstraint(String packageName, String expression, Declaration[] declarations, MVELCompilationUnit compilationUnit, IndexUtil.ConstraintType constraintType, Declaration indexingDeclaration, InternalReadAccessor extractor, boolean isUnification) {
        this.packageName = packageName;
        this.expression = expression;
        this.compilationUnit = compilationUnit;
        this.constraintType = indexingDeclaration != null ? constraintType : IndexUtil.ConstraintType.UNKNOWN;
        this.declarations = declarations == null ? new Declaration[]{} : declarations;
        this.indexingDeclaration = indexingDeclaration;
        this.extractor = extractor;
        this.isUnification = isUnification;
    }

    protected String getAccessedClass() {
        return this.extractor instanceof ClassFieldReader ? ((ClassFieldReader)this.extractor).getClassName() : (this.extractor instanceof MVELObjectClassFieldReader ? ((MVELObjectClassFieldReader)this.extractor).getClassName() : null);
    }

    @Override
    public void setReadAccessor(InternalReadAccessor readAccessor) {
        this.extractor = readAccessor;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public boolean isUnification() {
        return this.isUnification;
    }

    public void unsetUnification() {
        this.isUnification = false;
    }

    @Override
    public boolean isIndexable(short nodeType) {
        return this.getConstraintType().isIndexableForNode(nodeType);
    }

    @Override
    public IndexUtil.ConstraintType getConstraintType() {
        return this.constraintType;
    }

    @Override
    public FieldValue getField() {
        return this.fieldValue;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        if (this.isUnification) {
            throw new UnsupportedOperationException("Should not be called");
        }
        return this.evaluate(handle, workingMemory, null);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        if (this.isUnification) {
            if (((UnificationContextEntry)context).getVariable() != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(handle, mvelContextEntry.workingMemory, mvelContextEntry.leftTuple);
    }

    @Override
    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        if (this.isUnification) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[((UnificationContextEntry)context).getReader().getIndex()];
            if (v != null) {
                return true;
            }
            context = ((UnificationContextEntry)context).getContextEntry();
        }
        MvelContextEntry mvelContextEntry = (MvelContextEntry)context;
        return this.evaluate(mvelContextEntry.rightHandle, mvelContextEntry.workingMemory, tuple);
    }

    protected boolean evaluate(InternalFactHandle handle, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        if (!this.jitted) {
            if (this.conditionEvaluator == null) {
                this.createMvelConditionEvaluator(workingMemory);
            }
            if (!this.isDynamic && this.invocationCounter.getAndIncrement() == 20) {
                this.jitEvaluator(handle, workingMemory, leftTuple);
            }
        }
        return this.conditionEvaluator.evaluate(handle, workingMemory, leftTuple);
    }

    protected void createMvelConditionEvaluator(InternalWorkingMemory workingMemory) {
        if (this.compilationUnit != null) {
            MVELDialectRuntimeData data = this.getMVELDialectRuntimeData(workingMemory);
            ExecutableStatement statement = (ExecutableStatement)this.compilationUnit.getCompiledExpression(data);
            ParserConfiguration configuration = statement instanceof CompiledExpression ? ((CompiledExpression)statement).getParserConfiguration() : data.getParserConfiguration();
            this.conditionEvaluator = new MvelConditionEvaluator(this.compilationUnit, configuration, statement, this.declarations, this.getAccessedClass());
        } else {
            this.conditionEvaluator = new MvelConditionEvaluator(this.getParserConfiguration(workingMemory), this.expression, this.declarations, this.getAccessedClass());
        }
    }

    protected boolean forceJitEvaluator(InternalFactHandle handle, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        boolean mvelValue;
        try {
            mvelValue = this.conditionEvaluator.evaluate(handle, workingMemory, leftTuple);
        }
        catch (ClassCastException cce) {
            mvelValue = false;
        }
        this.jitEvaluator(handle, workingMemory, leftTuple);
        return mvelValue;
    }

    protected void jitEvaluator(InternalFactHandle handle, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        this.jitted = true;
        ExecutorHolder.executor.execute(new ConditionJitter(this, handle, workingMemory, leftTuple));
    }

    private void executeJitting(InternalFactHandle handle, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        InternalKnowledgeBase kBase = workingMemory.getKnowledgeBase();
        if (MemoryUtil.permGenStats.isUsageThresholdExceeded(kBase.getConfiguration().getPermGenThreshold())) {
            return;
        }
        try {
            ClassLoader classLoader = kBase.getRootClassLoader();
            if (this.analyzedCondition == null) {
                this.analyzedCondition = ((MvelConditionEvaluator)this.conditionEvaluator).getAnalyzedCondition(handle, workingMemory, leftTuple);
            }
            this.conditionEvaluator = ASMConditionEvaluatorJitter.jitEvaluator(this.expression, this.analyzedCondition, this.declarations, classLoader, leftTuple);
        }
        catch (Throwable t) {
            logger.warn("Exception jitting: " + this.expression + " This is NOT an error and NOT prevent the correct execution since the constraint will be evaluated in intrepreted mode");
        }
    }

    @Override
    public ContextEntry createContextEntry() {
        if (this.declarations.length == 0) {
            return null;
        }
        ContextEntry contextEntry = new MvelContextEntry(this.declarations);
        if (this.isUnification) {
            contextEntry = new UnificationContextEntry(contextEntry, this.declarations[0]);
        }
        return contextEntry;
    }

    @Override
    public AbstractHashTable.FieldIndex getFieldIndex() {
        this.indexingDeclaration.getPattern().setOffset(this.declarations[0].getPattern().getOffset());
        return new AbstractHashTable.FieldIndex(this.extractor, this.indexingDeclaration, INDEX_EVALUATOR);
    }

    @Override
    public InternalReadAccessor getFieldExtractor() {
        return this.extractor;
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.declarations;
    }

    public Declaration getIndexingDeclaration() {
        return this.indexingDeclaration;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        for (int i = 0; i < this.declarations.length; ++i) {
            if (!this.declarations[i].equals(oldDecl)) continue;
            if (this.compilationUnit != null) {
                this.compilationUnit.replaceDeclaration(this.declarations[i], newDecl);
            }
            this.declarations[i] = newDecl;
            break;
        }
        if (this.indexingDeclaration != null && this.indexingDeclaration.equals(oldDecl)) {
            this.indexingDeclaration = newDecl;
        }
    }

    public long getListenedPropertyMask(List<String> settableProperties) {
        return this.analyzedCondition != null ? this.calculateMask(this.analyzedCondition, settableProperties) : this.calculateMaskFromExpression(settableProperties);
    }

    private long calculateMaskFromExpression(List<String> settableProperties) {
        String[] simpleExpressions;
        long mask = 0L;
        for (String simpleExpression : simpleExpressions = this.expression.split("\\Q&&\\E|\\Q||\\E")) {
            String propertyName = this.getPropertyNameFromSimpleExpression(simpleExpression);
            if (propertyName.length() == 0) continue;
            if (propertyName.equals("this")) {
                return Long.MAX_VALUE;
            }
            int pos = settableProperties.indexOf(propertyName);
            if (pos < 0 && Character.isUpperCase(propertyName.charAt(0))) {
                propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
                pos = settableProperties.indexOf(propertyName);
            }
            if (pos < 0) continue;
            mask = BitMaskUtil.set(mask, pos);
        }
        return mask;
    }

    private String getPropertyNameFromSimpleExpression(String simpleExpression) {
        StringBuilder propertyNameBuilder = new StringBuilder();
        int cursor = StringUtils.extractFirstIdentifier(simpleExpression, propertyNameBuilder, 0);
        String propertyName = propertyNameBuilder.toString();
        if (propertyName.equals("this")) {
            if (simpleExpression.charAt(cursor = StringUtils.skipBlanks(simpleExpression, cursor)) != '.') {
                return "this";
            }
            propertyNameBuilder = new StringBuilder();
            StringUtils.extractFirstIdentifier(simpleExpression, propertyNameBuilder, cursor);
            propertyName = propertyNameBuilder.toString();
        }
        if (propertyName.startsWith("is") || propertyName.startsWith("get")) {
            int exprPos = simpleExpression.indexOf(propertyName);
            int propNameEnd = exprPos + propertyName.length();
            if (simpleExpression.length() > propNameEnd + 2 && simpleExpression.charAt(propNameEnd) == '(') {
                propertyName = ClassUtils.getter2property(propertyName);
            }
        }
        return propertyName;
    }

    private long calculateMask(ConditionAnalyzer.Condition condition, List<String> settableProperties) {
        if (condition instanceof ConditionAnalyzer.SingleCondition) {
            return this.calculateMask((ConditionAnalyzer.SingleCondition)condition, settableProperties);
        }
        long mask = 0L;
        for (ConditionAnalyzer.Condition c : ((ConditionAnalyzer.CombinedCondition)condition).getConditions()) {
            mask |= this.calculateMask(c, settableProperties);
        }
        return mask;
    }

    private long calculateMask(ConditionAnalyzer.SingleCondition condition, List<String> settableProperties) {
        String propertyName = this.getFirstInvokedPropertyName(condition.getLeft());
        if (propertyName == null) {
            return Long.MAX_VALUE;
        }
        int pos = settableProperties.indexOf(propertyName);
        if (pos < 0) {
            throw new RuntimeException("Unknown property: " + propertyName);
        }
        return 1L << pos;
    }

    private String getFirstInvokedPropertyName(ConditionAnalyzer.Expression expression) {
        if (!(expression instanceof ConditionAnalyzer.EvaluatedExpression)) {
            return null;
        }
        List<ConditionAnalyzer.Invocation> invocations = ((ConditionAnalyzer.EvaluatedExpression)expression).invocations;
        ConditionAnalyzer.Invocation invocation = invocations.get(0);
        if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
            Method method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
            if (method == null) {
                if (invocations.size() > 1) {
                    invocation = invocations.get(1);
                    if (invocation instanceof ConditionAnalyzer.MethodInvocation) {
                        method = ((ConditionAnalyzer.MethodInvocation)invocation).getMethod();
                    } else if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
                        return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
                    }
                } else {
                    return null;
                }
            }
            return ClassUtils.getter2property(method.getName());
        }
        if (invocation instanceof ConditionAnalyzer.FieldAccessInvocation) {
            return ((ConditionAnalyzer.FieldAccessInvocation)invocation).getField().getName();
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.packageName);
        out.writeObject(this.expression);
        out.writeObject(this.declarations);
        out.writeObject(this.indexingDeclaration);
        out.writeObject(this.extractor);
        out.writeObject((Object)this.constraintType);
        out.writeBoolean(this.isUnification);
        out.writeBoolean(this.isDynamic);
        out.writeObject(this.fieldValue);
        out.writeObject(this.compilationUnit);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.packageName = (String)in.readObject();
        this.expression = (String)in.readObject();
        this.declarations = (Declaration[])in.readObject();
        this.indexingDeclaration = (Declaration)in.readObject();
        this.extractor = (InternalReadAccessor)in.readObject();
        this.constraintType = (IndexUtil.ConstraintType)((Object)in.readObject());
        this.isUnification = in.readBoolean();
        this.isDynamic = in.readBoolean();
        this.fieldValue = (FieldValue)in.readObject();
        this.compilationUnit = (MVELCompilationUnit)in.readObject();
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public MvelConstraint cloneIfInUse() {
        MvelConstraint clone = (MvelConstraint)super.cloneIfInUse();
        if (clone != this) {
            clone.conditionEvaluator = null;
        }
        return clone;
    }

    @Override
    public MvelConstraint clone() {
        Declaration[] clonedDeclarations = new Declaration[this.declarations.length];
        System.arraycopy(this.declarations, 0, clonedDeclarations, 0, this.declarations.length);
        MvelConstraint clone = new MvelConstraint();
        clone.setType(this.getType());
        clone.packageName = this.packageName;
        clone.expression = this.expression;
        clone.constraintType = this.constraintType;
        clone.declarations = clonedDeclarations;
        clone.indexingDeclaration = this.indexingDeclaration;
        clone.extractor = this.extractor;
        clone.isUnification = this.isUnification;
        clone.isDynamic = this.isDynamic;
        clone.conditionEvaluator = this.conditionEvaluator;
        clone.compilationUnit = this.compilationUnit != null ? this.compilationUnit.clone() : null;
        return clone;
    }

    public int hashCode() {
        if (this.isAlphaHashable()) {
            return 29 * this.getLeftForEqualExpression().hashCode() + 31 * this.fieldValue.hashCode();
        }
        return this.expression.hashCode();
    }

    private String getLeftForEqualExpression() {
        return this.expression.substring(0, this.expression.indexOf("==")).trim();
    }

    private boolean isAlphaHashable() {
        return this.fieldValue != null && this.constraintType == IndexUtil.ConstraintType.EQUAL && this.getType() == Constraint.ConstraintType.ALPHA;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != MvelConstraint.class) {
            return false;
        }
        MvelConstraint other = (MvelConstraint)object;
        if (this.isAlphaHashable() ? !other.isAlphaHashable() || !this.getLeftForEqualExpression().equals(other.getLeftForEqualExpression()) || !this.fieldValue.equals(other.fieldValue) : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.declarations.length != other.declarations.length) {
            return false;
        }
        for (int i = 0; i < this.declarations.length; ++i) {
            if (this.declarations[i].getExtractor().equals(other.declarations[i].getExtractor())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.expression;
    }

    protected ParserConfiguration getParserConfiguration(InternalWorkingMemory workingMemory) {
        return this.getMVELDialectRuntimeData(workingMemory).getParserConfiguration();
    }

    protected MVELDialectRuntimeData getMVELDialectRuntimeData(InternalWorkingMemory workingMemory) {
        return (MVELDialectRuntimeData)workingMemory.getKnowledgeBase().getPackage(this.packageName).getDialectRuntimeRegistry().getDialectData("mvel");
    }

    public static class PlainIndexEvaluator
    implements IndexEvaluator {
        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, Object object1, InternalReadAccessor extractor2, Object object2) {
            Object value1 = extractor1.getValue(workingMemory, object1);
            Object value2 = extractor2.getValue(workingMemory, object2);
            if (value1 == null) {
                return value2 == null;
            }
            if (value1 instanceof String) {
                return value2 != null && value1.equals(value2.toString());
            }
            return value1.equals(value2);
        }
    }

    public static class UnificationContextEntry
    implements ContextEntry {
        private ContextEntry contextEntry;
        private Declaration declaration;
        private Variable variable;
        private ArrayElementReader reader;

        public UnificationContextEntry() {
        }

        public UnificationContextEntry(ContextEntry contextEntry, Declaration declaration) {
            this.contextEntry = contextEntry;
            this.declaration = declaration;
            this.reader = (ArrayElementReader)this.declaration.getExtractor();
        }

        public ContextEntry getContextEntry() {
            return this.contextEntry;
        }

        public ArrayElementReader getReader() {
            return this.reader;
        }

        @Override
        public ContextEntry getNext() {
            return this.contextEntry.getNext();
        }

        @Override
        public void resetFactHandle() {
            this.contextEntry.resetFactHandle();
        }

        @Override
        public void resetTuple() {
            this.contextEntry.resetTuple();
            this.variable = null;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.contextEntry.setNext(entry);
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.contextEntry.updateFromFactHandle(workingMemory, handle);
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            DroolsQuery query = (DroolsQuery)tuple.get(0).getObject();
            Variable v = query.getVariables()[this.reader.getIndex()];
            if (v == null) {
                this.variable = null;
                this.contextEntry.updateFromTuple(workingMemory, tuple);
            } else {
                this.variable = v;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.contextEntry = (ContextEntry)in.readObject();
            this.declaration = (Declaration)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.contextEntry);
            out.writeObject(this.declaration);
        }

        public Variable getVariable() {
            return this.variable;
        }
    }

    public static class MvelContextEntry
    implements ContextEntry {
        protected ContextEntry next;
        protected LeftTuple leftTuple;
        protected InternalFactHandle rightHandle;
        protected Declaration[] declarations;
        protected transient InternalWorkingMemory workingMemory;

        public MvelContextEntry() {
        }

        public MvelContextEntry(Declaration[] declarations) {
            this.declarations = declarations;
        }

        @Override
        public ContextEntry getNext() {
            return this.next;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.next = entry;
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
            this.leftTuple = leftTuple;
            this.workingMemory = workingMemory;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.rightHandle = handle;
        }

        @Override
        public void resetTuple() {
            this.leftTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.workingMemory = null;
            this.rightHandle = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.rightHandle);
            out.writeObject(this.declarations);
            out.writeObject(this.next);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (LeftTuple)in.readObject();
            this.rightHandle = (InternalFactHandle)in.readObject();
            this.declarations = (Declaration[])in.readObject();
            this.next = (ContextEntry)in.readObject();
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }

        public InternalFactHandle getRight() {
            return this.rightHandle;
        }

        public Declaration[] getDeclarations() {
            return this.declarations;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }
    }

    private static class ExecutorHolder {
        private static final Executor executor = ExecutorProviderFactory.getExecutorProvider().getExecutor();

        private ExecutorHolder() {
        }
    }

    private static class ConditionJitter
    implements Runnable {
        private MvelConstraint mvelConstraint;
        private InternalFactHandle rightHandle;
        private InternalWorkingMemory workingMemory;
        private LeftTuple leftTuple;

        private ConditionJitter(MvelConstraint mvelConstraint, InternalFactHandle rightHandle, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
            this.mvelConstraint = mvelConstraint;
            this.rightHandle = rightHandle;
            this.workingMemory = workingMemory;
            this.leftTuple = leftTuple;
        }

        @Override
        public void run() {
            this.mvelConstraint.executeJitting(this.rightHandle, this.workingMemory, this.leftTuple);
            this.mvelConstraint = null;
            this.rightHandle = null;
            this.workingMemory = null;
            this.leftTuple = null;
        }
    }
}

