/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.variable.descriptor;

import java.beans.PropertyDescriptor;
import org.optaplanner.core.impl.domain.common.PropertyAccessor;
import org.optaplanner.core.impl.domain.common.ReflectionPropertyAccessor;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;

public abstract class VariableDescriptor {
    protected final EntityDescriptor entityDescriptor;
    protected final PropertyAccessor variablePropertyAccessor;

    public VariableDescriptor(EntityDescriptor entityDescriptor, PropertyDescriptor propertyDescriptor) {
        this.entityDescriptor = entityDescriptor;
        this.variablePropertyAccessor = new ReflectionPropertyAccessor(propertyDescriptor);
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public String getVariableName() {
        return this.variablePropertyAccessor.getName();
    }

    public Class<?> getVariablePropertyType() {
        return this.variablePropertyAccessor.getPropertyType();
    }

    public Object getValue(Object entity) {
        return this.variablePropertyAccessor.executeGetter(entity);
    }

    public void setValue(Object entity, Object value) {
        this.variablePropertyAccessor.executeSetter(entity, value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variablePropertyAccessor.getName() + " of " + this.entityDescriptor.getEntityClass().getName() + ")";
    }
}

