/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;

public class DowncastingValueSelector
extends AbstractValueSelector {
    protected final ValueSelector childValueSelector;
    protected final Class<?> downcastEntityClass;

    public DowncastingValueSelector(ValueSelector childValueSelector, Class<?> downcastEntityClass) {
        this.childValueSelector = childValueSelector;
        this.downcastEntityClass = downcastEntityClass;
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    public ValueSelector getChildValueSelector() {
        return this.childValueSelector;
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        if (!this.downcastEntityClass.isInstance(entity)) {
            return 0L;
        }
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        if (!this.downcastEntityClass.isInstance(entity)) {
            return Iterators.emptyIterator();
        }
        return this.childValueSelector.iterator(entity);
    }

    public String toString() {
        return "Downcasting(" + this.childValueSelector + ")";
    }
}

