/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.phase.custom;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.AbstractPhase;
import org.optaplanner.core.impl.phase.custom.CustomPhase;
import org.optaplanner.core.impl.phase.custom.CustomPhaseCommand;
import org.optaplanner.core.impl.phase.custom.scope.CustomPhaseScope;
import org.optaplanner.core.impl.phase.custom.scope.CustomStepScope;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;

public class DefaultCustomPhase
extends AbstractPhase
implements CustomPhase {
    protected List<CustomPhaseCommand> customPhaseCommandList;
    protected boolean forceUpdateBestSolution;

    public void setCustomPhaseCommandList(List<CustomPhaseCommand> customPhaseCommandList) {
        this.customPhaseCommandList = customPhaseCommandList;
    }

    public void setForceUpdateBestSolution(boolean forceUpdateBestSolution) {
        this.forceUpdateBestSolution = forceUpdateBestSolution;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        CustomPhaseScope phaseScope = new CustomPhaseScope(solverScope);
        this.phaseStarted(phaseScope);
        CustomStepScope stepScope = new CustomStepScope(phaseScope);
        Iterator<CustomPhaseCommand> commandIterator = this.customPhaseCommandList.iterator();
        while (!this.termination.isPhaseTerminated(phaseScope) && commandIterator.hasNext()) {
            CustomPhaseCommand customPhaseCommand = commandIterator.next();
            this.stepStarted(stepScope);
            this.doStep(stepScope, customPhaseCommand);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            stepScope = new CustomStepScope(phaseScope);
        }
        this.phaseEnded(phaseScope);
    }

    public void phaseStarted(CustomPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
    }

    public void stepStarted(CustomStepScope stepScope) {
        super.stepStarted(stepScope);
    }

    private void doStep(CustomStepScope stepScope, CustomPhaseCommand customPhaseCommand) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        customPhaseCommand.changeWorkingSolution(scoreDirector);
        int uninitializedVariableCount = scoreDirector.getSolutionDescriptor().countUninitializedVariables(stepScope.getWorkingSolution());
        stepScope.setUninitializedVariableCount(uninitializedVariableCount);
        Score score = scoreDirector.calculateScore();
        stepScope.setScore(score);
        this.bestSolutionRecaller.processWorkingSolutionDuringStep(stepScope);
    }

    public void stepEnded(CustomStepScope stepScope) {
        super.stepEnded(stepScope);
        boolean bestScoreImproved = stepScope.getBestScoreImproved();
        if (this.forceUpdateBestSolution && !bestScoreImproved) {
            DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
            Solution newBestSolution = solverScope.getScoreDirector().cloneWorkingSolution();
            this.bestSolutionRecaller.updateBestSolution(solverScope, newBestSolution, stepScope.getUninitializedVariableCount());
        }
        CustomPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpent = phaseScope.calculateSolverTimeMillisSpent();
            this.logger.debug("    Custom step ({}), time spent ({}), score ({}), {} best score ({}).", new Object[]{stepScope.getStepIndex(), timeMillisSpent, stepScope.getScore(), bestScoreImproved ? "new" : (this.forceUpdateBestSolution ? "forced" : "   "), phaseScope.getBestScoreWithUninitializedPrefix()});
        }
    }

    public void phaseEnded(CustomPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.logger.info("Custom phase ({}) ended: step total ({}), time spent ({}), best score ({}).", new Object[]{this.phaseIndex, phaseScope.getNextStepIndex(), phaseScope.calculateSolverTimeMillisSpent(), phaseScope.getBestScore()});
    }
}

