/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.common.swingui.TangoColorFactory;
import org.optaplanner.examples.common.swingui.timetable.TimeTablePanel;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.Examination;
import org.optaplanner.examples.examination.domain.FollowingExam;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.swingui.InstitutionParametrizationDialog;

public class ExaminationPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/examination/swingui/examinationLogo.png";
    private final TimeTablePanel<Room, Period> roomsPanel;
    private InstitutionParametrizationDialog institutionParametrizationDialog;
    private AbstractAction institutionParametrizationEditAction;
    private int maximumPeriodDuration;
    private int maximumRoomCapacity;

    public ExaminationPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.roomsPanel = new TimeTablePanel();
        tabbedPane.add("Rooms", new JScrollPane(this.roomsPanel));
        this.add((Component)tabbedPane, "Center");
        this.add((Component)this.createFooterPanel(), "South");
        this.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
    }

    private JPanel createFooterPanel() {
        JPanel footerPanel = new JPanel(new FlowLayout(1));
        this.institutionParametrizationEditAction = new AbstractAction("Edit scoring parameters"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExaminationPanel.this.solutionBusiness.isSolving()) {
                    JOptionPane.showMessageDialog(ExaminationPanel.this.getTopLevelAncestor(), "The GUI does not support this action yet during solving.\nOptaPlanner itself does support it.\n\nTerminate solving first and try again.", "Unsupported in GUI", 0);
                    return;
                }
                ExaminationPanel.this.institutionParametrizationDialog.setInstitutionParametrization(ExaminationPanel.this.getExamination().getInstitutionParametrization());
                ExaminationPanel.this.institutionParametrizationDialog.setVisible(true);
            }
        };
        this.institutionParametrizationEditAction.setEnabled(false);
        footerPanel.add(new JButton(this.institutionParametrizationEditAction));
        return footerPanel;
    }

    @Override
    public void setSolverAndPersistenceFrame(SolverAndPersistenceFrame solverAndPersistenceFrame) {
        super.setSolverAndPersistenceFrame(solverAndPersistenceFrame);
        this.institutionParametrizationDialog = new InstitutionParametrizationDialog((Frame)solverAndPersistenceFrame, this);
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private Examination getExamination() {
        return (Examination)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        this.roomsPanel.reset();
        Examination examination = (Examination)solution;
        this.refreshMaximums(examination);
        this.defineGrid(examination);
        this.fillCells(examination);
        this.institutionParametrizationEditAction.setEnabled(true);
        this.repaint();
    }

    private void refreshMaximums(Examination examination) {
        this.maximumPeriodDuration = 0;
        for (Period period : examination.getPeriodList()) {
            int periodDuration = period.getDuration();
            if (periodDuration <= this.maximumPeriodDuration) continue;
            this.maximumPeriodDuration = periodDuration;
        }
        this.maximumRoomCapacity = 0;
        for (Room room : examination.getRoomList()) {
            int roomCapacity = room.getCapacity();
            if (roomCapacity <= this.maximumRoomCapacity) continue;
            this.maximumRoomCapacity = roomCapacity;
        }
    }

    private void defineGrid(Examination examination) {
        JButton footprint = new JButton("99999999");
        footprint.setMargin(new Insets(0, 0, 0, 0));
        int footprintWidth = footprint.getPreferredSize().width;
        this.roomsPanel.defineColumnHeaderByKey(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN);
        for (Room room : examination.getRoomList()) {
            this.roomsPanel.defineColumnHeader(room, footprintWidth);
        }
        this.roomsPanel.defineColumnHeader(null, footprintWidth);
        this.roomsPanel.defineRowHeaderByKey(TimeTablePanel.HeaderRowKey.HEADER_ROW);
        for (Period period : examination.getPeriodList()) {
            this.roomsPanel.defineRowHeader(period);
        }
        this.roomsPanel.defineRowHeader(null);
    }

    private void fillCells(Examination examination) {
        this.roomsPanel.addCornerHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Time"), null));
        this.fillRoomCells(examination);
        this.fillPeriodCells(examination);
        this.fillExamCells(examination);
    }

    private void fillRoomCells(Examination examination) {
        for (Room room : examination.getRoomList()) {
            this.roomsPanel.addColumnHeader(room, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel(room.getLabel(), new RoomIcon(room), 0), "Capacity: " + room.getCapacity()));
        }
        this.roomsPanel.addColumnHeader(null, TimeTablePanel.HeaderRowKey.HEADER_ROW, this.createHeaderPanel(new JLabel("Unassigned", 0), null));
    }

    private void fillPeriodCells(Examination examination) {
        for (Period period : examination.getPeriodList()) {
            this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, period, this.createHeaderPanel(new JLabel(period.getLabel(), new PeriodIcon(period), 2), "Duration: " + period.getDuration()));
        }
        this.roomsPanel.addRowHeader(TimeTablePanel.HeaderColumnKey.HEADER_COLUMN, null, this.createHeaderPanel(new JLabel("Unassigned"), null));
    }

    private void fillExamCells(Examination examination) {
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        for (Exam exam : examination.getExamList()) {
            Color examColor = tangoColorFactory.pickColor(exam);
            this.roomsPanel.addCell(exam.getRoom(), exam.getPeriod(), this.createButton(exam, examColor, "Duration: " + exam.getTopicDuration() + " - Student size: " + exam.getTopicStudentSize()));
        }
    }

    private JPanel createHeaderPanel(JLabel label, String toolTipText) {
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
        }
        JPanel headerPanel = new JPanel(new BorderLayout());
        headerPanel.add((Component)label, "North");
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColorFactory.ALUMINIUM_5), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return headerPanel;
    }

    private JButton createButton(Exam exam, Color color, String toolTipText) {
        JButton button = new JButton(new ExamAction(exam));
        if (toolTipText != null) {
            button.setToolTipText(toolTipText);
        }
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBackground(color);
        if (exam instanceof FollowingExam) {
            button.setForeground(TangoColorFactory.ALUMINIUM_5);
        }
        return button;
    }

    private class ExamIcon
    implements Icon {
        private static final int DIAMETER = 14;
        private static final int ICON_WIDTH = 10;
        private static final int ICON_HEIGHT = 14;
        private final Exam exam;

        private ExamIcon(Exam exam) {
            this.exam = exam;
        }

        @Override
        public int getIconWidth() {
            return 24;
        }

        @Override
        public int getIconHeight() {
            return 14;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillOval(x, y, 14, 14);
            g.setColor(TangoColorFactory.ALUMINIUM_4);
            g.fillArc(x, y, 14, 14, 90, -(360 * this.exam.getTopicDuration() / ExaminationPanel.this.maximumPeriodDuration));
            g.setColor(TangoColorFactory.ALUMINIUM_6);
            g.drawOval(x, y, 14, 14);
            g.setColor(Color.WHITE);
            g.fillRect((x += 15) + 1, y, 8, 14);
            g.setColor(TangoColorFactory.ALUMINIUM_4);
            int capacityHeight = 14 * this.exam.getTopicStudentSize() / ExaminationPanel.this.maximumRoomCapacity;
            g.fillRect(x + 1, y + (14 - capacityHeight), 8, capacityHeight);
            g.setColor(TangoColorFactory.ALUMINIUM_6);
            g.drawRect(x + 1, y, 8, 14);
        }
    }

    private class RoomIcon
    implements Icon {
        private static final int ICON_WIDTH = 10;
        private static final int ICON_HEIGHT = 14;
        private final Room room;

        private RoomIcon(Room room) {
            this.room = room;
        }

        @Override
        public int getIconWidth() {
            return 10;
        }

        @Override
        public int getIconHeight() {
            return 14;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(TangoColorFactory.ALUMINIUM_6);
            g.fillRect(x + 1, y, 8, 14);
            g.setColor(Color.WHITE);
            int capacityHeight = 14 * this.room.getCapacity() / ExaminationPanel.this.maximumRoomCapacity;
            g.fillRect(x + 1, y + (14 - capacityHeight), 8, capacityHeight);
            g.setColor(TangoColorFactory.ALUMINIUM_6);
            g.drawRect(x + 1, y, 8, 14);
        }
    }

    private class PeriodIcon
    implements Icon {
        private static final int DIAMETER = 14;
        private final Period period;

        private PeriodIcon(Period period) {
            this.period = period;
        }

        @Override
        public int getIconWidth() {
            return 14;
        }

        @Override
        public int getIconHeight() {
            return 14;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(TangoColorFactory.ALUMINIUM_6);
            g.fillOval(x, y, 14, 14);
            g.setColor(Color.WHITE);
            g.fillArc(x, y, 14, 14, 90, -(360 * this.period.getDuration() / ExaminationPanel.this.maximumPeriodDuration));
            g.setColor(TangoColorFactory.ALUMINIUM_6);
            g.drawOval(x, y, 14, 14);
        }
    }

    private class ExamAction
    extends AbstractAction {
        private Exam exam;

        public ExamAction(Exam exam) {
            super(exam.getLabel(), new ExamIcon(exam));
            this.exam = exam;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 2));
            listFieldsPanel.add(new JLabel("Period:"));
            List<Period> periodList = ExaminationPanel.this.getExamination().getPeriodList();
            JComboBox<Object> periodListField = new JComboBox<Object>(periodList.toArray());
            periodListField.setSelectedItem(this.exam.getPeriod());
            listFieldsPanel.add(periodListField);
            listFieldsPanel.add(new JLabel("Room:"));
            List<Room> roomList = ExaminationPanel.this.getExamination().getRoomList();
            JComboBox<Object> roomListField = new JComboBox<Object>(roomList.toArray());
            roomListField.setSelectedItem(this.exam.getRoom());
            listFieldsPanel.add(roomListField);
            int result = JOptionPane.showConfirmDialog(ExaminationPanel.this.getRootPane(), listFieldsPanel, "Select period and room", 2);
            if (result == 0) {
                Period toPeriod = (Period)periodListField.getSelectedItem();
                ExaminationPanel.this.solutionBusiness.doChangeMove(this.exam, "period", toPeriod);
                Room toRoom = (Room)roomListField.getSelectedItem();
                ExaminationPanel.this.solutionBusiness.doChangeMove(this.exam, "room", toRoom);
                ExaminationPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

