/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.config.statistic;

import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.calculatecount.CalculateCountProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreProblemStatistic;

public enum ProblemStatisticType implements StatisticType
{
    BEST_SCORE,
    STEP_SCORE,
    CALCULATE_COUNT_PER_SECOND,
    BEST_SOLUTION_MUTATION,
    MOVE_COUNT_PER_STEP,
    MEMORY_USE;


    public ProblemStatistic buildProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult) {
        switch (this) {
            case BEST_SCORE: {
                return new BestScoreProblemStatistic(problemBenchmarkResult);
            }
            case STEP_SCORE: {
                return new StepScoreProblemStatistic(problemBenchmarkResult);
            }
            case CALCULATE_COUNT_PER_SECOND: {
                return new CalculateCountProblemStatistic(problemBenchmarkResult);
            }
            case BEST_SOLUTION_MUTATION: {
                return new BestSolutionMutationProblemStatistic(problemBenchmarkResult);
            }
            case MOVE_COUNT_PER_STEP: {
                return new MoveCountPerStepProblemStatistic(problemBenchmarkResult);
            }
            case MEMORY_USE: {
                return new MemoryUseProblemStatistic(problemBenchmarkResult);
            }
        }
        throw new IllegalStateException("The problemStatisticType (" + this + ") is not implemented.");
    }
}

