/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestscore;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreStatisticPoint;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public class BestScoreSingleStatistic
extends SingleStatistic<BestScoreStatisticPoint> {
    private final BestScoreSingleStatisticListener listener = new BestScoreSingleStatisticListener();
    private List<BestScoreStatisticPoint> pointList = new ArrayList<BestScoreStatisticPoint>();

    public BestScoreSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        super(singleBenchmarkResult, ProblemStatisticType.BEST_SCORE);
    }

    @Override
    public List<BestScoreStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void setPointList(List<BestScoreStatisticPoint> pointList) {
        this.pointList = pointList;
    }

    @Override
    public void open(Solver solver) {
        solver.addEventListener((SolverEventListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        solver.removeEventListener((SolverEventListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return BestScoreStatisticPoint.buildCsvLine("timeMillisSpent", "score");
    }

    @Override
    protected BestScoreStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new BestScoreStatisticPoint(Long.valueOf(csvLine.get(0)), scoreDefinition.parseScore(csvLine.get(1)));
    }

    private class BestScoreSingleStatisticListener
    implements SolverEventListener<Solution> {
        private BestScoreSingleStatisticListener() {
        }

        public void bestSolutionChanged(BestSolutionChangedEvent<Solution> event) {
            BestScoreSingleStatistic.this.pointList.add(new BestScoreStatisticPoint(event.getTimeMillisSpent(), event.getNewBestSolution().getScore()));
        }
    }
}

