/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.score.buildin.hardsoft.HardSoftScoreDefinition;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.examination.domain.Exam;
import org.optaplanner.examples.examination.domain.InstitutionParametrization;
import org.optaplanner.examples.examination.domain.Period;
import org.optaplanner.examples.examination.domain.PeriodPenalty;
import org.optaplanner.examples.examination.domain.Room;
import org.optaplanner.examples.examination.domain.RoomPenalty;
import org.optaplanner.examples.examination.domain.Student;
import org.optaplanner.examples.examination.domain.Topic;
import org.optaplanner.examples.examination.domain.solver.TopicConflict;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="Examination")
public class Examination
extends AbstractPersistable
implements Solution<HardSoftScore> {
    private InstitutionParametrization institutionParametrization;
    private List<Student> studentList;
    private List<Topic> topicList;
    private List<Period> periodList;
    private List<Room> roomList;
    private List<PeriodPenalty> periodPenaltyList;
    private List<RoomPenalty> roomPenaltyList;
    private List<Exam> examList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={HardSoftScoreDefinition.class})
    private HardSoftScore score;

    public InstitutionParametrization getInstitutionParametrization() {
        return this.institutionParametrization;
    }

    public void setInstitutionParametrization(InstitutionParametrization institutionParametrization) {
        this.institutionParametrization = institutionParametrization;
    }

    public List<Student> getStudentList() {
        return this.studentList;
    }

    public void setStudentList(List<Student> studentList) {
        this.studentList = studentList;
    }

    public List<Topic> getTopicList() {
        return this.topicList;
    }

    public void setTopicList(List<Topic> topicList) {
        this.topicList = topicList;
    }

    @ValueRangeProvider(id="periodRange")
    public List<Period> getPeriodList() {
        return this.periodList;
    }

    public void setPeriodList(List<Period> periodList) {
        this.periodList = periodList;
    }

    @ValueRangeProvider(id="roomRange")
    public List<Room> getRoomList() {
        return this.roomList;
    }

    public void setRoomList(List<Room> roomList) {
        this.roomList = roomList;
    }

    public List<PeriodPenalty> getPeriodPenaltyList() {
        return this.periodPenaltyList;
    }

    public void setPeriodPenaltyList(List<PeriodPenalty> periodPenaltyList) {
        this.periodPenaltyList = periodPenaltyList;
    }

    public List<RoomPenalty> getRoomPenaltyList() {
        return this.roomPenaltyList;
    }

    public void setRoomPenaltyList(List<RoomPenalty> roomPenaltyList) {
        this.roomPenaltyList = roomPenaltyList;
    }

    @PlanningEntityCollectionProperty
    public List<Exam> getExamList() {
        return this.examList;
    }

    public void setExamList(List<Exam> examList) {
        this.examList = examList;
    }

    @Override
    public HardSoftScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(HardSoftScore score) {
        this.score = score;
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<Comparable<AbstractPersistable>> facts = new ArrayList<Comparable<AbstractPersistable>>();
        facts.add(this.institutionParametrization);
        facts.addAll(this.topicList);
        facts.addAll(this.periodList);
        facts.addAll(this.roomList);
        facts.addAll(this.periodPenaltyList);
        facts.addAll(this.roomPenaltyList);
        facts.addAll(this.precalculateTopicConflictList());
        return facts;
    }

    private List<TopicConflict> precalculateTopicConflictList() {
        ArrayList<TopicConflict> topicConflictList = new ArrayList<TopicConflict>();
        for (Topic leftTopic : this.topicList) {
            for (Topic rightTopic : this.topicList) {
                if (leftTopic.getId() >= rightTopic.getId()) continue;
                int studentSize = 0;
                for (Student student : leftTopic.getStudentList()) {
                    if (!rightTopic.getStudentList().contains(student)) continue;
                    ++studentSize;
                }
                if (studentSize <= 0) continue;
                topicConflictList.add(new TopicConflict(leftTopic, rightTopic, studentSize));
            }
        }
        return topicConflictList;
    }
}

