/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic;

import com.thoughtworks.xstream.annotations.XStreamInclude;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestscore.BestScoreProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.calculatecount.CalculateCountProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.common.GraphSupport;
import org.optaplanner.benchmark.impl.statistic.memoryuse.MemoryUseProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.movecountperstep.MoveCountPerStepProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreProblemStatistic;

@XStreamInclude(value={BestScoreProblemStatistic.class, StepScoreProblemStatistic.class, CalculateCountProblemStatistic.class, BestSolutionMutationProblemStatistic.class, MoveCountPerStepProblemStatistic.class, MemoryUseProblemStatistic.class})
public abstract class ProblemStatistic {
    @XStreamOmitField
    protected ProblemBenchmarkResult problemBenchmarkResult;
    protected final ProblemStatisticType problemStatisticType;
    protected List<String> warningList = null;

    protected ProblemStatistic(ProblemBenchmarkResult problemBenchmarkResult, ProblemStatisticType problemStatisticType) {
        this.problemBenchmarkResult = problemBenchmarkResult;
        this.problemStatisticType = problemStatisticType;
    }

    public ProblemBenchmarkResult getProblemBenchmarkResult() {
        return this.problemBenchmarkResult;
    }

    public void setProblemBenchmarkResult(ProblemBenchmarkResult problemBenchmarkResult) {
        this.problemBenchmarkResult = problemBenchmarkResult;
    }

    public ProblemStatisticType getProblemStatisticType() {
        return this.problemStatisticType;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.problemBenchmarkResult.getName() + "_" + this.problemStatisticType.name());
    }

    public List<String> getWarningList() {
        return this.warningList;
    }

    public List<SingleStatistic> getSingleStatisticList() {
        List<SingleBenchmarkResult> singleBenchmarkResultList = this.problemBenchmarkResult.getSingleBenchmarkResultList();
        ArrayList<SingleStatistic> singleStatisticList = new ArrayList<SingleStatistic>(singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            singleStatisticList.add(singleBenchmarkResult.getEffectiveSingleStatisticMap().get(this.problemStatisticType));
        }
        return singleStatisticList;
    }

    public abstract SingleStatistic createSingleStatistic(SingleBenchmarkResult var1);

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        this.warningList = new ArrayList<String>();
        this.fillWarningList();
    }

    public abstract void writeGraphFiles(BenchmarkReport var1);

    protected void fillWarningList() {
    }

    protected File writeChartToImageFile(JFreeChart chart, String fileNameBase) {
        File chartFile = new File(this.problemBenchmarkResult.getProblemReportDirectory(), fileNameBase + ".png");
        GraphSupport.writeChartToImageFile(chart, chartFile);
        return chartFile;
    }
}

