/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.entity.descriptor;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.domain.variable.CustomShadowVariable;
import org.optaplanner.core.api.domain.variable.InverseRelationShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.policy.DescriptorPolicy;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.CustomShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.InverseRelationShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.VariableDescriptor;
import org.optaplanner.core.impl.domain.variable.listener.VariableListener;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;

public class EntityDescriptor {
    private final SolutionDescriptor solutionDescriptor;
    private final Class<?> entityClass;
    private final BeanInfo entityBeanInfo;
    private SelectionFilter movableEntitySelectionFilter;
    private SelectionSorter decreasingDifficultySorter;
    private List<EntityDescriptor> inheritedEntityDescriptorList;
    private Map<String, GenuineVariableDescriptor> declaredGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor> declaredShadowVariableDescriptorMap;
    private Map<String, GenuineVariableDescriptor> effectiveGenuineVariableDescriptorMap;
    private Map<String, ShadowVariableDescriptor> effectiveShadowVariableDescriptorMap;

    public EntityDescriptor(SolutionDescriptor solutionDescriptor, Class<?> entityClass) {
        this.solutionDescriptor = solutionDescriptor;
        this.entityClass = entityClass;
        try {
            this.entityBeanInfo = Introspector.getBeanInfo(entityClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The entityClass (" + entityClass + ") is not a valid java bean.", e);
        }
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processEntityAnnotations(descriptorPolicy);
        this.processMethodAnnotations(descriptorPolicy);
        this.processPropertyAnnotations(descriptorPolicy);
    }

    private void processEntityAnnotations(DescriptorPolicy descriptorPolicy) {
        PlanningEntity entityAnnotation = this.entityClass.getAnnotation(PlanningEntity.class);
        if (entityAnnotation == null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") has been specified as a planning entity in the configuration," + " but does not have a " + PlanningEntity.class.getSimpleName() + " annotation.");
        }
        this.processMovable(descriptorPolicy, entityAnnotation);
        this.processDifficulty(descriptorPolicy, entityAnnotation);
    }

    private void processMovable(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionFilter> movableEntitySelectionFilterClass = entityAnnotation.movableEntitySelectionFilter();
        if (movableEntitySelectionFilterClass == PlanningEntity.NullMovableEntitySelectionFilter.class) {
            movableEntitySelectionFilterClass = null;
        }
        if (movableEntitySelectionFilterClass != null) {
            this.movableEntitySelectionFilter = ConfigUtils.newInstance(this, "movableEntitySelectionFilterClass", movableEntitySelectionFilterClass);
        }
    }

    private void processDifficulty(DescriptorPolicy descriptorPolicy, PlanningEntity entityAnnotation) {
        Class<? extends SelectionSorterWeightFactory> difficultyWeightFactoryClass;
        Class<? extends Comparator> difficultyComparatorClass = entityAnnotation.difficultyComparatorClass();
        if (difficultyComparatorClass == PlanningEntity.NullDifficultyComparator.class) {
            difficultyComparatorClass = null;
        }
        if ((difficultyWeightFactoryClass = entityAnnotation.difficultyWeightFactoryClass()) == PlanningEntity.NullDifficultyWeightFactory.class) {
            difficultyWeightFactoryClass = null;
        }
        if (difficultyComparatorClass != null && difficultyWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") cannot have a difficultyComparatorClass (" + difficultyComparatorClass.getName() + ") and a difficultyWeightFactoryClass (" + difficultyWeightFactoryClass.getName() + ") at the same time.");
        }
        if (difficultyComparatorClass != null) {
            Comparator difficultyComparator = ConfigUtils.newInstance(this, "difficultyComparatorClass", difficultyComparatorClass);
            this.decreasingDifficultySorter = new ComparatorSelectionSorter(difficultyComparator, SelectionSorterOrder.DESCENDING);
        }
        if (difficultyWeightFactoryClass != null) {
            SelectionSorterWeightFactory difficultyWeightFactory = ConfigUtils.newInstance(this, "difficultyWeightFactoryClass", difficultyWeightFactoryClass);
            this.decreasingDifficultySorter = new WeightFactorySelectionSorter(difficultyWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    private void processMethodAnnotations(DescriptorPolicy descriptorPolicy) {
        for (Method method : this.entityClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ValueRangeProvider.class)) continue;
            descriptorPolicy.addFromEntityValueRangeProvider(method);
        }
    }

    private void processPropertyAnnotations(DescriptorPolicy descriptorPolicy) {
        PropertyDescriptor[] propertyDescriptors = this.entityBeanInfo.getPropertyDescriptors();
        this.declaredGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor>(propertyDescriptors.length);
        this.declaredShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor>(propertyDescriptors.length);
        boolean noPlanningVariableAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            VariableDescriptor variableDescriptor;
            Method propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter == null || propertyGetter.getDeclaringClass() != this.entityClass) continue;
            Object variableAnnotationClass = null;
            for (Class detectedAnnotationClass : Arrays.asList(PlanningVariable.class, InverseRelationShadowVariable.class, CustomShadowVariable.class)) {
                if (!propertyGetter.isAnnotationPresent(detectedAnnotationClass)) continue;
                if (variableAnnotationClass != null) {
                    throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a property (" + propertyDescriptor.getName() + ") that has both a " + ((Class)variableAnnotationClass).getSimpleName() + " annotation and a " + detectedAnnotationClass.getSimpleName() + " annotation.");
                }
                variableAnnotationClass = detectedAnnotationClass;
            }
            if (variableAnnotationClass == null) continue;
            noPlanningVariableAnnotation = false;
            if (propertyDescriptor.getWriteMethod() == null) {
                throw new IllegalStateException("The entityClass (" + this.entityClass + ") has a " + ((Class)variableAnnotationClass).getSimpleName() + " annotated property (" + propertyDescriptor.getName() + ") that should have a setter.");
            }
            if (variableAnnotationClass.equals(PlanningVariable.class)) {
                variableDescriptor = new GenuineVariableDescriptor(this, propertyDescriptor);
                this.declaredGenuineVariableDescriptorMap.put(propertyDescriptor.getName(), (GenuineVariableDescriptor)variableDescriptor);
                ((GenuineVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
                continue;
            }
            if (variableAnnotationClass.equals(InverseRelationShadowVariable.class)) {
                variableDescriptor = new InverseRelationShadowVariableDescriptor(this, propertyDescriptor);
                this.declaredShadowVariableDescriptorMap.put(propertyDescriptor.getName(), (ShadowVariableDescriptor)variableDescriptor);
                ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
                continue;
            }
            if (variableAnnotationClass.equals(CustomShadowVariable.class)) {
                variableDescriptor = new CustomShadowVariableDescriptor(this, propertyDescriptor);
                this.declaredShadowVariableDescriptorMap.put(propertyDescriptor.getName(), (ShadowVariableDescriptor)variableDescriptor);
                ((ShadowVariableDescriptor)variableDescriptor).processAnnotations(descriptorPolicy);
                continue;
            }
            throw new IllegalStateException("The variableAnnotationClass (" + variableAnnotationClass + ") is not implemented.");
        }
        if (noPlanningVariableAnnotation) {
            throw new IllegalStateException("The entityClass (" + this.entityClass + ") should have at least 1 getter with a " + PlanningVariable.class.getSimpleName() + " annotation or a shadow variable annotation.");
        }
    }

    public void linkInheritedEntityDescriptors(DescriptorPolicy descriptorPolicy) {
        this.inheritedEntityDescriptorList = new ArrayList<EntityDescriptor>(4);
        this.investigateParentsToLinkInherited(this.entityClass);
        this.createEffectiveVariableDescriptorMaps();
    }

    private void investigateParentsToLinkInherited(Class<?> investigateClass) {
        if (investigateClass == null || investigateClass.isArray()) {
            return;
        }
        this.linkInherited(investigateClass.getSuperclass());
        for (Class<?> superInterface : investigateClass.getInterfaces()) {
            this.linkInherited(superInterface);
        }
    }

    private void linkInherited(Class<?> investigateClass) {
        EntityDescriptor superEntityDescriptor = this.solutionDescriptor.getEntityDescriptorStrict(investigateClass);
        if (superEntityDescriptor != null) {
            this.inheritedEntityDescriptorList.add(superEntityDescriptor);
        } else {
            this.investigateParentsToLinkInherited(investigateClass);
        }
    }

    public void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            shadowVariableDescriptor.linkShadowSources(descriptorPolicy);
        }
    }

    private void createEffectiveVariableDescriptorMaps() {
        this.effectiveGenuineVariableDescriptorMap = new LinkedHashMap<String, GenuineVariableDescriptor>(this.declaredGenuineVariableDescriptorMap.size());
        this.effectiveShadowVariableDescriptorMap = new LinkedHashMap<String, ShadowVariableDescriptor>(this.declaredShadowVariableDescriptorMap.size());
        for (EntityDescriptor inheritedEntityDescriptor : this.inheritedEntityDescriptorList) {
            this.effectiveGenuineVariableDescriptorMap.putAll(inheritedEntityDescriptor.getGenuineVariableDescriptorMap());
            this.effectiveShadowVariableDescriptorMap.putAll(inheritedEntityDescriptor.getShadowVariableDescriptorMap());
        }
        this.effectiveGenuineVariableDescriptorMap.putAll(this.declaredGenuineVariableDescriptorMap);
        this.effectiveShadowVariableDescriptorMap.putAll(this.declaredShadowVariableDescriptorMap);
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.solutionDescriptor;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean matchesEntity(Object entity) {
        return this.entityClass.isAssignableFrom(entity.getClass());
    }

    public boolean hasMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter != null;
    }

    public SelectionFilter getMovableEntitySelectionFilter() {
        return this.movableEntitySelectionFilter;
    }

    public SelectionSorter getDecreasingDifficultySorter() {
        return this.decreasingDifficultySorter;
    }

    public boolean hasProperty(String propertyName) {
        for (PropertyDescriptor propertyDescriptor : this.entityBeanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyDeclaredGenuineVariableDescriptor() {
        return !this.declaredGenuineVariableDescriptorMap.isEmpty();
    }

    public Collection<String> getGenuineVariableNameSet() {
        return this.effectiveGenuineVariableDescriptorMap.keySet();
    }

    public Map<String, GenuineVariableDescriptor> getGenuineVariableDescriptorMap() {
        return this.effectiveGenuineVariableDescriptorMap;
    }

    public Map<String, ShadowVariableDescriptor> getShadowVariableDescriptorMap() {
        return this.effectiveShadowVariableDescriptorMap;
    }

    public Collection<GenuineVariableDescriptor> getGenuineVariableDescriptors() {
        return this.effectiveGenuineVariableDescriptorMap.values();
    }

    public boolean hasGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.containsKey(variableName);
    }

    public GenuineVariableDescriptor getGenuineVariableDescriptor(String variableName) {
        return this.effectiveGenuineVariableDescriptorMap.get(variableName);
    }

    public boolean hasShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.containsKey(variableName);
    }

    public ShadowVariableDescriptor getShadowVariableDescriptor(String variableName) {
        return this.effectiveShadowVariableDescriptorMap.get(variableName);
    }

    public void addDeclaredVariableListenersToMap(Map<VariableDescriptor, List<VariableListener>> variableListenerMap) {
        for (GenuineVariableDescriptor genuineVariableDescriptor : this.declaredGenuineVariableDescriptorMap.values()) {
            variableListenerMap.put(genuineVariableDescriptor, genuineVariableDescriptor.buildVariableListenerList());
        }
        for (ShadowVariableDescriptor shadowVariableDescriptor : this.declaredShadowVariableDescriptorMap.values()) {
            variableListenerMap.put(shadowVariableDescriptor, shadowVariableDescriptor.buildVariableListenerList());
        }
    }

    public Collection<VariableDescriptor> getDeclaredVariableDescriptors() {
        ArrayList<VariableDescriptor> variableDescriptors = new ArrayList<VariableDescriptor>(this.declaredGenuineVariableDescriptorMap.size() + this.declaredShadowVariableDescriptorMap.size());
        variableDescriptors.addAll(this.declaredGenuineVariableDescriptorMap.values());
        variableDescriptors.addAll(this.declaredShadowVariableDescriptorMap.values());
        return variableDescriptors;
    }

    public VariableDescriptor getVariableDescriptor(String variableName) {
        VariableDescriptor variableDescriptor = this.effectiveGenuineVariableDescriptorMap.get(variableName);
        if (variableDescriptor == null) {
            variableDescriptor = this.effectiveShadowVariableDescriptorMap.get(variableName);
        }
        return variableDescriptor;
    }

    public String buildInvalidVariableNameExceptionMessage(String variableName) {
        if (!this.hasProperty(variableName)) {
            String exceptionMessage = "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") does not exists as a property (getter/setter) on that class.\n" + "Check the spelling of the variableName (" + variableName + ").";
            if (variableName.length() >= 2 && !Character.isUpperCase(variableName.charAt(0)) && Character.isUpperCase(variableName.charAt(1))) {
                String correctedVariableName = variableName.substring(0, 1).toUpperCase() + variableName.substring(1);
                exceptionMessage = exceptionMessage + " It probably needs to be correctedVariableName (" + correctedVariableName + ") instead because the JavaBeans spec states" + " the first letter should be a upper case if the second is upper case.";
            }
            return exceptionMessage;
        }
        return "The variableName (" + variableName + ") for entityClass (" + this.entityClass + ") exists as a property (getter/setter) on that class," + " but not as an annotated as a planning variable.\n" + "Check if your planning entity's getter has the annotation " + PlanningVariable.class.getSimpleName() + " (or a shadow variable annotation).";
    }

    public List<Object> extractEntities(Solution solution) {
        return this.solutionDescriptor.getEntityListByEntityClass(solution, this.entityClass);
    }

    public long getVariableCount() {
        return this.effectiveGenuineVariableDescriptorMap.size();
    }

    public long getProblemScale(Solution solution, Object entity) {
        long problemScale = 1L;
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            problemScale *= variableDescriptor.getValueCount(solution, entity);
        }
        return problemScale;
    }

    public int countUninitializedVariables(Object entity) {
        int uninitializedVariableCount = 0;
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            ++uninitializedVariableCount;
        }
        return uninitializedVariableCount;
    }

    public boolean isInitialized(Object entity) {
        for (GenuineVariableDescriptor variableDescriptor : this.effectiveGenuineVariableDescriptorMap.values()) {
            if (variableDescriptor.isInitialized(entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entityClass.getName() + ")";
    }
}

