/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.concurrent;

import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.kie.api.concurrent.KieExecutors;

public class ExecutorProviderImpl
implements KieExecutors {
    public Executor getExecutor() {
        return ExecutorHolder.executor;
    }

    public Executor newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    }

    public <T> CompletionService<T> getCompletionService() {
        return new ExecutorCompletionService(this.getExecutor());
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger threadCount = new AtomicInteger();

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("drools-worker-" + threadCount.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private static class ExecutorHolder {
        private static final ExecutorService executor = new ThreadPoolExecutor(0, KieExecutors.Pool.SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory());

        private ExecutorHolder() {
        }
    }
}

