/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.PeriodPowerCost;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.persistence.CheapTimeDao;
import org.optaplanner.examples.cheaptime.solver.CheapTimeCostCalculator;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionExporter;

public class CheapTimeExporter
extends AbstractTxtSolutionExporter {
    public static void main(String[] args) {
        new CheapTimeExporter().convertAll();
    }

    public CheapTimeExporter() {
        super(new CheapTimeDao());
    }

    @Override
    public String getOutputFileSuffix() {
        return "txt";
    }

    @Override
    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new CheapTimeOutputBuilder();
    }

    public static class CheapTimeOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private CheapTimeSolution solution;

        @Override
        public void setSolution(Solution solution) {
            this.solution = (CheapTimeSolution)solution;
        }

        @Override
        public void writeSolution() throws IOException {
            int globalPeriodRangeTo = this.solution.getGlobalPeriodRangeTo();
            List<Machine> machineList = this.solution.getMachineList();
            List<PeriodPowerCost> periodPowerCostList = this.solution.getPeriodPowerCostList();
            this.bufferedWriter.write(machineList.size() + "\n");
            Map<Machine, List<Boolean>> machinePeriodActiveListMap = this.createMachinePeriodActiveListMap(machineList);
            for (Machine machine : machineList) {
                this.bufferedWriter.write(machine.getId() + "\n");
                List<Boolean> periodActiveList = machinePeriodActiveListMap.get(machine);
                int spinCount = 0;
                StringBuilder spinUpDownLines = new StringBuilder("");
                MachinePeriodStatus previousStatus = MachinePeriodStatus.OFF;
                long idleCostMicros = 0L;
                int lastSpinDown = Integer.MIN_VALUE;
                for (int i = 0; i < globalPeriodRangeTo; ++i) {
                    boolean active = periodActiveList.get(i);
                    if (active) {
                        if (previousStatus == MachinePeriodStatus.OFF) {
                            if (lastSpinDown >= 0) {
                                ++spinCount;
                                spinUpDownLines.append("0 ").append(lastSpinDown).append("\n");
                                lastSpinDown = Integer.MIN_VALUE;
                            }
                            ++spinCount;
                            spinUpDownLines.append("1 ").append(i).append("\n");
                        }
                        previousStatus = MachinePeriodStatus.ACTIVE;
                        continue;
                    }
                    if (previousStatus == MachinePeriodStatus.OFF) continue;
                    if (previousStatus == MachinePeriodStatus.ACTIVE) {
                        lastSpinDown = i - 1;
                    }
                    PeriodPowerCost periodPowerCost = periodPowerCostList.get(i);
                    if ((idleCostMicros += CheapTimeCostCalculator.multiplyTwoMicros(machine.getPowerConsumptionMicros(), periodPowerCost.getPowerCostMicros())) > machine.getSpinUpDownCostMicros()) {
                        idleCostMicros = 0L;
                        previousStatus = MachinePeriodStatus.OFF;
                        continue;
                    }
                    previousStatus = MachinePeriodStatus.IDLE;
                }
                if (previousStatus == MachinePeriodStatus.ACTIVE) {
                    lastSpinDown = globalPeriodRangeTo - 1;
                }
                if (lastSpinDown >= 0) {
                    ++spinCount;
                    spinUpDownLines.append("0 ").append(lastSpinDown).append("\n");
                    lastSpinDown = Integer.MIN_VALUE;
                }
                this.bufferedWriter.write(spinCount + "\n");
                this.bufferedWriter.write(spinUpDownLines.toString());
            }
            List<TaskAssignment> taskAssignmentList = this.solution.getTaskAssignmentList();
            this.bufferedWriter.write(taskAssignmentList.size() + "\n");
            for (TaskAssignment taskAssignment : taskAssignmentList) {
                this.bufferedWriter.write(taskAssignment.getTask().getId() + " " + taskAssignment.getMachine().getId() + " " + taskAssignment.getStartPeriod() + "\n");
            }
        }

        private Map<Machine, List<Boolean>> createMachinePeriodActiveListMap(List<Machine> machineList) {
            LinkedHashMap<Machine, List<Boolean>> machinePeriodActiveListMap = new LinkedHashMap<Machine, List<Boolean>>(machineList.size());
            if (this.solution.getGlobalPeriodRangeFrom() != 0) {
                throw new IllegalStateException("The globalPeriodRangeFrom (" + this.solution.getGlobalPeriodRangeFrom() + ") should be 0.");
            }
            for (Machine machine : machineList) {
                ArrayList<Boolean> periodActiveList = new ArrayList<Boolean>(this.solution.getGlobalPeriodRangeTo());
                for (int i = 0; i < this.solution.getGlobalPeriodRangeTo(); ++i) {
                    periodActiveList.add(false);
                }
                machinePeriodActiveListMap.put(machine, periodActiveList);
            }
            for (TaskAssignment taskAssignment : this.solution.getTaskAssignmentList()) {
                for (int i = taskAssignment.getStartPeriod().intValue(); i < taskAssignment.getEndPeriod(); ++i) {
                    ((List)machinePeriodActiveListMap.get(taskAssignment.getMachine())).set(i, true);
                }
            }
            return machinePeriodActiveListMap;
        }

        private static enum MachinePeriodStatus {
            OFF,
            IDLE,
            ACTIVE;

        }
    }
}

