/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.optaplanner.core.api.domain.solution.PlanningEntityCollectionProperty;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.domain.valuerange.ValueRangeProvider;
import org.optaplanner.core.api.score.buildin.simplelong.SimpleLongScore;
import org.optaplanner.core.impl.score.buildin.simplelong.SimpleLongScoreDefinition;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.tsp.domain.City;
import org.optaplanner.examples.tsp.domain.Domicile;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.persistence.xstream.impl.score.XStreamScoreConverter;

@PlanningSolution
@XStreamAlias(value="TravelingSalesmanTour")
public class TravelingSalesmanTour
extends AbstractPersistable
implements Solution<SimpleLongScore> {
    private String name;
    private List<City> cityList;
    private Domicile domicile;
    private List<Visit> visitList;
    @XStreamConverter(value=XStreamScoreConverter.class, types={SimpleLongScoreDefinition.class})
    private SimpleLongScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<City> getCityList() {
        return this.cityList;
    }

    public void setCityList(List<City> cityList) {
        this.cityList = cityList;
    }

    public Domicile getDomicile() {
        return this.domicile;
    }

    public void setDomicile(Domicile domicile) {
        this.domicile = domicile;
    }

    @PlanningEntityCollectionProperty
    @ValueRangeProvider(id="visitRange")
    public List<Visit> getVisitList() {
        return this.visitList;
    }

    public void setVisitList(List<Visit> visitList) {
        this.visitList = visitList;
    }

    @Override
    public SimpleLongScore getScore() {
        return this.score;
    }

    @Override
    public void setScore(SimpleLongScore score) {
        this.score = score;
    }

    @ValueRangeProvider(id="domicileRange")
    public List<Domicile> getDomicileRange() {
        return Collections.singletonList(this.domicile);
    }

    @Override
    public Collection<? extends Object> getProblemFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.cityList);
        facts.add(this.domicile);
        return facts;
    }
}

