/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.vehiclerouting.persistence;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.optaplanner.examples.vehiclerouting.domain.Customer;
import org.optaplanner.examples.vehiclerouting.domain.Depot;
import org.optaplanner.examples.vehiclerouting.domain.Location;
import org.optaplanner.examples.vehiclerouting.domain.Vehicle;
import org.optaplanner.examples.vehiclerouting.domain.VehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedCustomer;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedDepot;
import org.optaplanner.examples.vehiclerouting.domain.timewindowed.TimeWindowedVehicleRoutingSolution;
import org.optaplanner.examples.vehiclerouting.persistence.VehicleRoutingDao;

public class VehicleRoutingImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        VehicleRoutingImporter importer = new VehicleRoutingImporter();
        importer.convert("capacitated/A-n33-k6.vrp", "cvrp-32customers.xml");
        importer.convert("capacitated/A-n55-k9.vrp", "cvrp-54customers.xml");
        importer.convert("capacitated/F-n72-k4.vrp", "cvrp-72customers.xml");
        importer.convert("timewindowed/Solomon_025_C101.vrp", "cvrptw-25customers.xml");
        importer.convert("timewindowed/Solomon_100_R101.vrp", "cvrptw-100customers-A.xml");
        importer.convert("timewindowed/Solomon_100_R201.vrp", "cvrptw-100customers-B.xml");
        importer.convert("timewindowed/Homberger_0400_R1_4_1.vrp", "cvrptw-400customers.xml");
    }

    public VehicleRoutingImporter() {
        super(new VehicleRoutingDao());
    }

    public VehicleRoutingImporter(boolean withoutDao) {
        super(withoutDao);
    }

    @Override
    public String getInputFileSuffix() {
        return "vrp";
    }

    @Override
    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new VrpScheduleInputBuilder();
    }

    public static class VrpScheduleInputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        private VehicleRoutingSolution schedule;
        private int locationListSize;
        private int vehicleListSize;
        private int capacity;
        private Map<Long, Location> locationMap;
        private List<Depot> depotList;

        @Override
        public Solution readSolution() throws IOException {
            String firstLine = this.readStringValue();
            if (firstLine.matches("\\s*NAME\\s*:.*")) {
                this.schedule = new VehicleRoutingSolution();
                this.schedule.setId(0L);
                this.schedule.setName(this.removePrefixSuffixFromLine(firstLine, "\\s*NAME\\s*:", ""));
                this.readBasicFormat();
            } else if (this.splitBySpacesOrTabs(firstLine).length == 3) {
                this.schedule = new VehicleRoutingSolution();
                this.schedule.setId(0L);
                String[] tokens = this.splitBySpacesOrTabs(firstLine, 3);
                this.locationListSize = Integer.parseInt(tokens[0]);
                this.vehicleListSize = Integer.parseInt(tokens[1]);
                this.capacity = Integer.parseInt(tokens[2]);
                this.readCourseraFormat();
            } else {
                this.schedule = new TimeWindowedVehicleRoutingSolution();
                this.schedule.setId(0L);
                this.schedule.setName(firstLine);
                this.readTimeWindowedFormat();
            }
            BigInteger possibleSolutionSize = this.factorial(this.locationListSize + this.vehicleListSize - 1).divide(this.factorial(this.vehicleListSize - 1));
            this.logger.info("VehicleRoutingSolution {} has {} depots, {} vehicles and {} customers with a search space of {}.", new Object[]{this.getInputId(), this.schedule.getDepotList().size(), this.schedule.getVehicleList().size(), this.schedule.getCustomerList().size(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
            return this.schedule;
        }

        public void readBasicFormat() throws IOException {
            this.readBasicHeaders();
            this.readBasicLocationList();
            this.readBasicCustomerList();
            this.readBasicDepotList();
            this.createBasicVehicleList();
            this.readConstantLine("EOF");
        }

        private void readBasicHeaders() throws IOException {
            this.readUntilConstantLine("TYPE *: CVRP");
            this.locationListSize = this.readIntegerValue("DIMENSION *:");
            String edgeWeightType = this.readStringValue("EDGE_WEIGHT_TYPE *:");
            if (!edgeWeightType.equalsIgnoreCase("EUC_2D")) {
                throw new IllegalArgumentException("The edgeWeightType (" + edgeWeightType + ") is not supported.");
            }
            this.capacity = this.readIntegerValue("CAPACITY *:");
        }

        private void readBasicLocationList() throws IOException {
            this.readConstantLine("NODE_COORD_SECTION");
            ArrayList<Location> locationList = new ArrayList<Location>(this.locationListSize);
            this.locationMap = new HashMap<Long, Location>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 3);
                Location location = new Location();
                location.setId(Long.parseLong(lineTokens[0]));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                this.locationMap.put(location.getId(), location);
            }
            this.schedule.setLocationList(locationList);
        }

        private void readBasicCustomerList() throws IOException {
            this.readConstantLine("DEMAND_SECTION");
            ArrayList<Customer> customerList = new ArrayList<Customer>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 2);
                Customer customer = new Customer();
                long id = Long.parseLong(lineTokens[0]);
                customer.setId(id);
                Location location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The customer with id (" + id + ") has no location (" + location + ").");
                }
                customer.setLocation(location);
                int demand = Integer.parseInt(lineTokens[1]);
                customer.setDemand(demand);
                if (demand == 0) continue;
                customerList.add(customer);
            }
            this.schedule.setCustomerList(customerList);
        }

        private void readBasicDepotList() throws IOException {
            this.readConstantLine("DEPOT_SECTION");
            this.depotList = new ArrayList<Depot>(this.locationListSize);
            long id = this.readLongValue();
            while (id != -1L) {
                Depot depot = new Depot();
                depot.setId(id);
                Location location = this.locationMap.get(id);
                if (location == null) {
                    throw new IllegalArgumentException("The depot with id (" + id + ") has no location (" + location + ").");
                }
                depot.setLocation(location);
                this.depotList.add(depot);
                id = this.readLongValue();
            }
            this.schedule.setDepotList(this.depotList);
        }

        private void createBasicVehicleList() throws IOException {
            String inputFileName = this.inputFile.getName();
            if (inputFileName.toLowerCase().startsWith("tutorial")) {
                this.vehicleListSize = this.readIntegerValue("VEHICLES *:");
            } else {
                String inputFileNameRegex = "^.+\\-k(\\d+)\\.vrp$";
                if (!inputFileName.matches(inputFileNameRegex)) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") does not match the inputFileNameRegex (" + inputFileNameRegex + ").");
                }
                String vehicleListSizeString = inputFileName.replaceAll(inputFileNameRegex, "$1");
                try {
                    this.vehicleListSize = Integer.parseInt(vehicleListSizeString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The inputFileName (" + inputFileName + ") has a vehicleListSizeString (" + vehicleListSizeString + ") that is not a number.", e);
                }
            }
            this.createVehicleList();
        }

        private void createVehicleList() {
            ArrayList<Vehicle> vehicleList = new ArrayList<Vehicle>(this.vehicleListSize);
            long id = 0L;
            for (int i = 0; i < this.vehicleListSize; ++i) {
                Vehicle vehicle = new Vehicle();
                vehicle.setId(id);
                ++id;
                vehicle.setCapacity(this.capacity);
                vehicle.setDepot(this.depotList.get(0));
                vehicleList.add(vehicle);
            }
            this.schedule.setVehicleList(vehicleList);
        }

        public void readCourseraFormat() throws IOException {
            ArrayList<Location> locationList = new ArrayList<Location>(this.locationListSize);
            this.depotList = new ArrayList<Depot>(1);
            ArrayList<Customer> customerList = new ArrayList<Customer>(this.locationListSize);
            this.locationMap = new HashMap<Long, Location>(this.locationListSize);
            for (int i = 0; i < this.locationListSize; ++i) {
                String line = this.bufferedReader.readLine();
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 3);
                Location location = new Location();
                location.setId(Long.valueOf(i));
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                if (lineTokens.length >= 4) {
                    location.setName(lineTokens[3]);
                }
                locationList.add(location);
                if (i == 0) {
                    Depot depot = new Depot();
                    depot.setId(Long.valueOf(i));
                    depot.setLocation(location);
                    this.depotList.add(depot);
                    continue;
                }
                Customer customer = new Customer();
                customer.setId(Long.valueOf(i));
                customer.setLocation(location);
                int demand = Integer.parseInt(lineTokens[0]);
                customer.setDemand(demand);
                if (demand == 0) continue;
                customerList.add(customer);
            }
            this.schedule.setLocationList(locationList);
            this.schedule.setDepotList(this.depotList);
            this.schedule.setCustomerList(customerList);
            this.createVehicleList();
        }

        public void readTimeWindowedFormat() throws IOException {
            this.readTimeWindowedHeaders();
            this.readTimeWindowedDepotAndCustomers();
            this.createVehicleList();
        }

        private void readTimeWindowedHeaders() throws IOException {
            this.readEmptyLine();
            this.readConstantLine("VEHICLE");
            this.readConstantLine("NUMBER +CAPACITY");
            String[] lineTokens = this.splitBySpacesOrTabs(this.readStringValue(), 2);
            this.vehicleListSize = Integer.parseInt(lineTokens[0]);
            this.capacity = Integer.parseInt(lineTokens[1]);
            this.readEmptyLine();
            this.readConstantLine("CUSTOMER");
            this.readConstantLine("CUST\\s+NO\\.\\s+XCOORD\\.\\s+YCOORD\\.\\s+DEMAND\\s+READY\\s+TIME\\s+DUE\\s+DATE\\s+SERVICE\\s+TIME");
            this.readEmptyLine();
        }

        private void readTimeWindowedDepotAndCustomers() throws IOException {
            String line = this.bufferedReader.readLine();
            int locationListSizeEstimation = 25;
            ArrayList<Location> locationList = new ArrayList<Location>(locationListSizeEstimation);
            this.depotList = new ArrayList<Depot>(1);
            TimeWindowedDepot depot = null;
            ArrayList<Customer> customerList = new ArrayList<Customer>(locationListSizeEstimation);
            boolean first = true;
            while (line != null && !line.trim().isEmpty()) {
                String[] lineTokens = this.splitBySpacesOrTabs(line.trim(), 7);
                long id = Long.parseLong(lineTokens[0]);
                Location location = new Location();
                location.setId(id);
                location.setLatitude(Double.parseDouble(lineTokens[1]));
                location.setLongitude(Double.parseDouble(lineTokens[2]));
                locationList.add(location);
                int demand = Integer.parseInt(lineTokens[3]);
                int readyTime = Integer.parseInt(lineTokens[4]) * 1000;
                int dueTime = Integer.parseInt(lineTokens[5]) * 1000;
                int serviceDuration = Integer.parseInt(lineTokens[6]) * 1000;
                if (first) {
                    depot = new TimeWindowedDepot();
                    depot.setId(id);
                    depot.setLocation(location);
                    if (demand != 0) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a demand (" + demand + ").");
                    }
                    depot.setReadyTime(readyTime);
                    depot.setDueTime(dueTime);
                    if (serviceDuration != 0) {
                        throw new IllegalArgumentException("The depot with id (" + id + ") has a serviceDuration (" + serviceDuration + ").");
                    }
                    this.depotList.add(depot);
                    first = false;
                } else {
                    TimeWindowedCustomer customer = new TimeWindowedCustomer();
                    customer.setId(id);
                    customer.setLocation(location);
                    customer.setDemand(demand);
                    customer.setReadyTime(readyTime);
                    int maximumDueTime = depot.getDueTime() - serviceDuration - location.getDistance(depot.getLocation());
                    if (dueTime > maximumDueTime) {
                        this.logger.warn("The customer ({})'s dueTime ({}) was automatically reduced to maximumDueTime ({}) because of the depot's dueTime ({}).", new Object[]{customer, dueTime, maximumDueTime, depot.getDueTime()});
                        dueTime = maximumDueTime;
                    }
                    customer.setDueTime(dueTime);
                    customer.setServiceDuration(serviceDuration);
                    if (demand != 0) {
                        customerList.add(customer);
                    }
                }
                line = this.bufferedReader.readLine();
            }
            this.schedule.setLocationList(locationList);
            this.schedule.setDepotList(this.depotList);
            this.schedule.setCustomerList(customerList);
            this.locationListSize = locationList.size();
        }
    }
}

