/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.tsp.swingui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.examples.common.swingui.SolverAndPersistenceFrame;
import org.optaplanner.examples.tsp.domain.City;
import org.optaplanner.examples.tsp.domain.Standstill;
import org.optaplanner.examples.tsp.domain.TravelingSalesmanTour;
import org.optaplanner.examples.tsp.domain.Visit;
import org.optaplanner.examples.tsp.swingui.TspListPanel;
import org.optaplanner.examples.tsp.swingui.TspWorldPanel;

public class TspPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/optaplanner/examples/tsp/swingui/tspLogo.png";
    private TspWorldPanel tspWorldPanel;
    private TspListPanel tspListPanel;
    private Long nextCityId = null;

    public TspPanel() {
        this.setLayout(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        this.tspWorldPanel = new TspWorldPanel(this);
        this.tspWorldPanel.setPreferredSize(PREFERRED_SCROLLABLE_VIEWPORT_SIZE);
        tabbedPane.add("World", this.tspWorldPanel);
        this.tspListPanel = new TspListPanel(this);
        JScrollPane tspListScrollPane = new JScrollPane(this.tspListPanel);
        tabbedPane.add("List", tspListScrollPane);
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    public boolean isWrapInScrollPane() {
        return false;
    }

    @Override
    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    public TravelingSalesmanTour getTravelingSalesmanTour() {
        return (TravelingSalesmanTour)this.solutionBusiness.getSolution();
    }

    @Override
    public void resetPanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        this.tspWorldPanel.resetPanel(travelingSalesmanTour);
        this.tspListPanel.resetPanel(travelingSalesmanTour);
        this.resetNextCityId();
    }

    private void resetNextCityId() {
        long highestCityId = 0L;
        for (City city : this.getTravelingSalesmanTour().getCityList()) {
            if (highestCityId >= city.getId()) continue;
            highestCityId = city.getId();
        }
        this.nextCityId = highestCityId + 1L;
    }

    @Override
    public void updatePanel(Solution solution) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)solution;
        this.tspWorldPanel.updatePanel(travelingSalesmanTour);
        this.tspListPanel.updatePanel(travelingSalesmanTour);
    }

    public void doMove(Move move) {
        this.solutionBusiness.doMove(move);
    }

    public SolverAndPersistenceFrame getWorkflowFrame() {
        return this.solverAndPersistenceFrame;
    }

    public void insertCityAndVisit(double longitude, double latitude) {
        final City newCity = new City();
        newCity.setId(this.nextCityId);
        Long l = this.nextCityId;
        Long l2 = this.nextCityId = Long.valueOf(this.nextCityId + 1L);
        newCity.setLongitude(longitude);
        newCity.setLatitude(latitude);
        this.logger.info("Scheduling insertion of newCity ({}).", (Object)newCity);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            @Override
            public void doChange(ScoreDirector scoreDirector) {
                TravelingSalesmanTour solution = (TravelingSalesmanTour)scoreDirector.getWorkingSolution();
                scoreDirector.beforeProblemFactAdded(newCity);
                solution.getCityList().add(newCity);
                scoreDirector.afterProblemFactAdded(newCity);
                Visit newVisit = new Visit();
                newVisit.setId(newCity.getId());
                newVisit.setCity(newCity);
                scoreDirector.beforeEntityAdded(newVisit);
                solution.getVisitList().add(newVisit);
                scoreDirector.afterEntityAdded(newVisit);
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }

    public void doMove(Visit visit, Standstill toStandstill) {
        this.solutionBusiness.doChangeMove(visit, "previousStandstill", toStandstill);
    }
}

